/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.vmware.internal;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultStatus;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.alarm.AlarmSummary;

public class VmwareStatusProvider
implements StatusProvider {
    private final AlarmDao alarmDao;

    public VmwareStatusProvider(AlarmDao alarmDao) {
        this.alarmDao = Objects.requireNonNull(alarmDao);
    }

    public Map<VertexRef, Status> getStatusForVertices(BackendGraph graph, Collection<VertexRef> vertices, Criteria[] criteria) {
        List vmwareVertices = vertices.stream().filter(v -> v.getNamespace().equals(this.getNamespace())).map(v -> (AbstractVertex)v).collect(Collectors.toList());
        Map nodeIdMap = vmwareVertices.stream().filter(v -> v.getNodeID() != null).collect(Collectors.toMap(AbstractVertex::getNodeID, Function.identity()));
        Map<Integer, AlarmSummary> nodeIdToAlarmSummaryMap = this.getAlarmSummaries(nodeIdMap.keySet());
        HashMap resultMap = Maps.newHashMap();
        for (AbstractVertex eachVertex : vmwareVertices) {
            AlarmSummary alarmSummary = nodeIdToAlarmSummaryMap.get(eachVertex.getNodeID());
            if (alarmSummary == null) continue;
            resultMap.put(eachVertex, new DefaultStatus(alarmSummary.getMaxSeverity().getLabel(), 0L));
        }
        return resultMap;
    }

    public String getNamespace() {
        return "vmware";
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace().equals(namespace);
    }

    private Map<Integer, AlarmSummary> getAlarmSummaries(Set<Integer> nodeIds) {
        return this.alarmDao.getNodeAlarmSummariesIncludeAcknowledgedOnes(new ArrayList<Integer>(nodeIds)).stream().collect(Collectors.toMap(AlarmSummary::getNodeId, Function.identity()));
    }
}

