/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.collect.RowSortedTable;
import java.util.Map;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.api.FilterInfo;
import org.opennms.netmgt.measurements.api.FilterParam;

@FilterInfo(name="Derivative", description="Calculates the derivative (rate of change) between rows.")
public class Derivative
implements Filter {
    @FilterParam(key="inputColumn", required=true, displayName="Input", description="Input column.")
    private String m_inputColumn;
    @FilterParam(key="outputColumn", required=true, displayName="Output", description="Output column.")
    private String m_outputColumn;

    protected Derivative() {
    }

    public Derivative(String inputColumn, String outputColumn) {
        this.m_inputColumn = inputColumn;
        this.m_outputColumn = outputColumn;
    }

    public void filter(RowSortedTable<Long, String, Double> qrAsTable) throws Exception {
        Map.Entry lastEntry = null;
        for (Map.Entry entry : qrAsTable.column((Object)this.m_inputColumn).entrySet()) {
            long step;
            double slope = Double.NaN;
            if (lastEntry != null && (step = (Long)entry.getKey() - (Long)lastEntry.getKey()) != 0L) {
                slope = ((Double)entry.getValue() - (Double)lastEntry.getValue()) / (double)step;
            }
            qrAsTable.put((Object)((Long)entry.getKey()), (Object)this.m_outputColumn, (Object)slope);
            lastEntry = entry;
        }
    }
}

