/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.tsrm;

import com.ibm.maximo.CreateSHSIMPINCResponseType;
import com.ibm.maximo.CreateSHSIMPINCType;
import com.ibm.maximo.INCIDENTKeyType;
import com.ibm.maximo.MXBooleanType;
import com.ibm.maximo.MXDateTimeType;
import com.ibm.maximo.MXStringQueryType;
import com.ibm.maximo.MXStringType;
import com.ibm.maximo.QuerySHSIMPINCResponseType;
import com.ibm.maximo.QuerySHSIMPINCType;
import com.ibm.maximo.SHSIMPINCINCIDENTType;
import com.ibm.maximo.SHSIMPINCQueryType;
import com.ibm.maximo.SHSIMPINCSetType;
import com.ibm.maximo.UpdateSHSIMPINCType;
import com.ibm.maximo.wsdl.shsimpinc.SHSIMPINC;
import com.ibm.maximo.wsdl.shsimpinc.SHSIMPINCPortType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.TrustManager;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.CollectionUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.core.utils.AnyServerX509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsrmTicketerPlugin
implements Plugin {
    private static final Logger LOG = LoggerFactory.getLogger(TsrmTicketerPlugin.class);
    SHSIMPINCPortType port;

    public TsrmTicketerPlugin() {
        this.getService();
    }

    private SHSIMPINCPortType getService() {
        SHSIMPINC service = new SHSIMPINC();
        this.port = service.getSHSIMPINCSOAP12Port();
        Client cxfClient = ClientProxy.getClient((Object)this.port);
        try {
            cxfClient.getRequestContext().put(Message.ENDPOINT_ADDRESS, TsrmTicketerPlugin.getProperties().getProperty("tsrm.url"));
            HTTPConduit http = (HTTPConduit)cxfClient.getConduit();
            String stictSSL = TsrmTicketerPlugin.getProperties().getProperty("tsrm.ssl.strict");
            if (!Boolean.parseBoolean(stictSSL)) {
                LOG.debug("Disabling strict SSL checking.");
                TrustManager[] simpleTrustManager = new TrustManager[]{new AnyServerX509TrustManager()};
                TLSClientParameters tlsParams = new TLSClientParameters();
                tlsParams.setTrustManagers(simpleTrustManager);
                tlsParams.setDisableCNCheck(true);
                http.setTlsClientParameters(tlsParams);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to load tsrm properties ", (Throwable)e);
        }
        LoggingInInterceptor loggingInInterceptor = new LoggingInInterceptor();
        loggingInInterceptor.setPrettyLogging(true);
        cxfClient.getInInterceptors().add(loggingInInterceptor);
        LoggingOutInterceptor loggingOutInterceptor = new LoggingOutInterceptor();
        loggingOutInterceptor.setPrettyLogging(true);
        cxfClient.getOutInterceptors().add(loggingOutInterceptor);
        return this.port;
    }

    public Ticket get(String ticketId) throws PluginException {
        SHSIMPINCQueryType queryType = new SHSIMPINCQueryType();
        SHSIMPINCQueryType.INCIDENT incidentQuery = new SHSIMPINCQueryType.INCIDENT();
        List<MXStringQueryType> ticketList = incidentQuery.getTICKETID();
        MXStringQueryType ticketQuery = new MXStringQueryType();
        ticketQuery.setValue(ticketId);
        ticketList.add(ticketQuery);
        queryType.setINCIDENT(incidentQuery);
        QuerySHSIMPINCType queryIncident = new QuerySHSIMPINCType();
        queryIncident.setSHSIMPINCQuery(queryType);
        QuerySHSIMPINCResponseType response = this.port.querySHSIMPINC(queryIncident);
        if (!CollectionUtils.isEmpty(response.getSHSIMPINCSet().getINCIDENT())) {
            SHSIMPINCINCIDENTType incident = response.getSHSIMPINCSet().getINCIDENT().get(0);
            if (incident != null) {
                Ticket ticket = new Ticket();
                MXStringType affectedPerson = new MXStringType();
                affectedPerson = incident.getAFFECTEDPERSON();
                MXStringType assetNum = new MXStringType();
                assetNum = incident.getASSETNUM();
                MXStringType classId = new MXStringType();
                classId = incident.getCLASS();
                MXStringType classStructureId = new MXStringType();
                classStructureId = incident.getCLASSSTRUCTUREID();
                MXStringType description = new MXStringType();
                description = incident.getDESCRIPTION();
                MXStringType longDescription = new MXStringType();
                longDescription = incident.getDESCRIPTIONLONGDESCRIPTION();
                MXStringType location = new MXStringType();
                location = incident.getLOCATION();
                MXStringType ownerGroup = new MXStringType();
                ownerGroup = incident.getOWNERGROUP();
                MXStringType reportedBy = new MXStringType();
                reportedBy = incident.getREPORTEDBY();
                MXStringType shsCallerType = new MXStringType();
                shsCallerType = incident.getSHSCALLERTYPE();
                MXStringType shsReasonForOutage = new MXStringType();
                shsReasonForOutage = incident.getSHSREASONFOROUTAGE();
                MXStringType shsResolution = new MXStringType();
                shsResolution = incident.getSHSRESOLUTION();
                MXStringType shsRoomNumber = new MXStringType();
                shsRoomNumber = incident.getSHSROOMNUMBER();
                MXStringType siteId = new MXStringType();
                siteId = incident.getSITEID();
                MXStringType source = new MXStringType();
                source = incident.getSOURCE();
                MXBooleanType statusIface = new MXBooleanType();
                statusIface = incident.getSTATUSIFACE();
                MXStringType ticketIdFromIncident = new MXStringType();
                ticketIdFromIncident = incident.getTICKETID();
                if (ticketIdFromIncident == null) {
                    return null;
                }
                ticket.setId(ticketIdFromIncident.getValue());
                if (affectedPerson != null) {
                    ticket.addAttribute("affectedPerson", affectedPerson.getValue());
                }
                if (assetNum != null) {
                    ticket.addAttribute("assetNum", assetNum.getValue());
                }
                if (classId != null) {
                    ticket.addAttribute("classId", classId.getValue());
                }
                if (classStructureId != null) {
                    ticket.addAttribute("classStructureId", classStructureId.getValue());
                }
                if (description != null) {
                    ticket.setSummary(description.getValue());
                }
                if (longDescription != null) {
                    ticket.setDetails(longDescription.getValue());
                }
                if (location != null) {
                    ticket.addAttribute("location", location.getValue());
                }
                if (ownerGroup != null) {
                    ticket.addAttribute("ownerGroup", ownerGroup.getValue());
                }
                if (reportedBy != null) {
                    ticket.setUser(reportedBy.getValue());
                }
                if (shsCallerType != null) {
                    ticket.addAttribute("shsCallerType", shsCallerType.getValue());
                }
                if (shsReasonForOutage != null) {
                    ticket.addAttribute("shsReasonForOutage", shsReasonForOutage.getValue());
                }
                if (shsResolution != null) {
                    ticket.addAttribute("shsResolution", shsResolution.getValue());
                }
                if (shsRoomNumber != null) {
                    ticket.addAttribute("shsRoomNumber", shsRoomNumber.getValue());
                }
                if (siteId != null) {
                    ticket.addAttribute("siteId", siteId.getValue());
                }
                if (source != null) {
                    ticket.addAttribute("source", source.getValue());
                }
                MXStringType status = new MXStringType();
                status = incident.getSTATUS();
                try {
                    if (status != null && status.getValue() != null && status.getValue().equals(TsrmTicketerPlugin.getProperties().getProperty("tsrm.status.open"))) {
                        ticket.setState(Ticket.State.OPEN);
                    } else if (status != null && status.getValue() != null && status.getValue().equals(TsrmTicketerPlugin.getProperties().getProperty("tsrm.status.close"))) {
                        ticket.setState(Ticket.State.CLOSED);
                    }
                }
                catch (IOException e) {
                    LOG.error("Unable to load tsrm.status from properties ", (Throwable)e);
                }
                if (statusIface != null) {
                    ticket.addAttribute("statusIface", statusIface.isValue().toString());
                }
                return ticket;
            }
            return null;
        }
        return null;
    }

    public void saveOrUpdate(Ticket ticket) throws PluginException {
        LOG.debug("saveOrUpdate called with ticket: {}", (Object)ticket);
        String ticketId = ticket.getId();
        if (StringUtils.isEmpty((String)ticketId)) {
            List<INCIDENTKeyType> incidentKeyList;
            SHSIMPINCINCIDENTType incident = new SHSIMPINCINCIDENTType();
            this.updateIncidentWithTicket(incident, ticket);
            SHSIMPINCSetType incSetType = new SHSIMPINCSetType();
            List<SHSIMPINCINCIDENTType> incidentList = incSetType.getINCIDENT();
            incidentList.add(incident);
            CreateSHSIMPINCType createIncidentType = new CreateSHSIMPINCType();
            createIncidentType.setSHSIMPINCSet(incSetType);
            CreateSHSIMPINCResponseType response = this.port.createSHSIMPINC(createIncidentType);
            if (response != null && !CollectionUtils.isEmpty(incidentKeyList = response.getINCIDENTMboKeySet().getINCIDENT())) {
                INCIDENTKeyType incidentKey = incidentKeyList.get(0);
                ticket.setId(incidentKey.getTICKETID().getValue());
            }
        } else {
            SHSIMPINCQueryType queryType = new SHSIMPINCQueryType();
            SHSIMPINCQueryType.INCIDENT incidentQuery = new SHSIMPINCQueryType.INCIDENT();
            List<MXStringQueryType> ticketList = incidentQuery.getTICKETID();
            MXStringQueryType ticketQuery = new MXStringQueryType();
            ticketQuery.setValue(ticketId);
            ticketList.add(ticketQuery);
            queryType.setINCIDENT(incidentQuery);
            QuerySHSIMPINCType queryIncident = new QuerySHSIMPINCType();
            queryIncident.setSHSIMPINCQuery(queryType);
            QuerySHSIMPINCResponseType response = this.port.querySHSIMPINC(queryIncident);
            if (!CollectionUtils.isEmpty(response.getSHSIMPINCSet().getINCIDENT())) {
                SHSIMPINCINCIDENTType incident = response.getSHSIMPINCSet().getINCIDENT().get(0);
                this.updateIncidentWithTicket(incident, ticket);
                UpdateSHSIMPINCType updateIncident = new UpdateSHSIMPINCType();
                SHSIMPINCSetType updateIncidentType = new SHSIMPINCSetType();
                updateIncidentType.getINCIDENT().add(incident);
                updateIncident.setSHSIMPINCSet(updateIncidentType);
                this.port.updateSHSIMPINC(updateIncident);
            }
        }
    }

    private void updateIncidentWithTicket(SHSIMPINCINCIDENTType incident, Ticket ticket) {
        if (!StringUtils.isEmpty((String)ticket.getAttribute("affectedPerson"))) {
            MXStringType affectedPerson = new MXStringType();
            affectedPerson.setValue(ticket.getAttribute("affectedPerson"));
            incident.setAFFECTEDPERSON(affectedPerson);
        }
        if (!StringUtils.isEmpty((String)ticket.getAttribute("assetNum"))) {
            MXStringType assetNum = new MXStringType();
            assetNum.setValue(ticket.getAttribute("assetNum"));
            incident.setASSETNUM(assetNum);
        }
        if (!StringUtils.isEmpty((String)ticket.getAttribute("classId"))) {
            MXStringType classId = new MXStringType();
            classId.setValue(ticket.getAttribute("classId"));
            incident.setCLASS(classId);
        }
        if (!StringUtils.isEmpty((String)ticket.getAttribute("classStructureId"))) {
            MXStringType classStructureId = new MXStringType();
            classStructureId.setValue(ticket.getAttribute("classStructureId"));
            incident.setCLASSSTRUCTUREID(classStructureId);
        }
        if (!StringUtils.isEmpty((String)ticket.getAttribute("commodity"))) {
            MXStringType commodity = new MXStringType();
            commodity.setValue(ticket.getAttribute("commodity"));
            incident.setCOMMODITY(commodity);
        }
        if (!StringUtils.isEmpty((String)ticket.getSummary())) {
            MXStringType description = new MXStringType();
            description.setValue(ticket.getSummary());
            incident.setDESCRIPTION(description);
        }
        if (!StringUtils.isEmpty((String)ticket.getDetails())) {
            MXStringType longDescription = new MXStringType();
            longDescription.setValue(ticket.getDetails());
            incident.setDESCRIPTIONLONGDESCRIPTION(longDescription);
        }
        if (!StringUtils.isEmpty((String)ticket.getAttribute("location"))) {
            MXStringType location = new MXStringType();
            location.setValue(ticket.getAttribute("location"));
            incident.setLOCATION(location);
        }
        if (!StringUtils.isEmpty((String)ticket.getAttribute("ownerGroup"))) {
            MXStringType ownerGroup = new MXStringType();
            ownerGroup.setValue(ticket.getAttribute("ownerGroup"));
            incident.setOWNERGROUP(ownerGroup);
        }
        if (!StringUtils.isEmpty((String)ticket.getUser())) {
            if (StringUtils.isEmpty((String)ticket.getId())) {
                MXStringType reportedBy = new MXStringType();
                reportedBy.setValue(ticket.getUser());
                incident.setREPORTEDBY(reportedBy);
            } else {
                MXDateTimeType date = new MXDateTimeType();
                GregorianCalendar calendarTime = new GregorianCalendar();
                calendarTime.setTime(new Date());
                JAXBElement jaxbElement = new JAXBElement(new QName(MXDateTimeType.class.getName()), MXDateTimeType.class, (Object)date);
                try {
                    XMLGregorianCalendar value = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendarTime);
                    date.setValue(value);
                    incident.setCHANGEDATE((JAXBElement<MXDateTimeType>)jaxbElement);
                }
                catch (DatatypeConfigurationException e) {
                    LOG.error("Unable to create changedDate", (Throwable)e);
                }
            }
        }
        if (!StringUtils.isEmpty((String)ticket.getAttribute("shsCallerType"))) {
            MXStringType shsCallerType = new MXStringType();
            shsCallerType.setValue(ticket.getAttribute("shsCallerType"));
            incident.setSHSCALLERTYPE(shsCallerType);
        }
        if (!StringUtils.isEmpty((String)ticket.getAttribute("shsReasonForOutage"))) {
            MXStringType shsReasonForOutage = new MXStringType();
            shsReasonForOutage.setValue(ticket.getAttribute("shsReasonForOutage"));
            incident.setSHSREASONFOROUTAGE(shsReasonForOutage);
        }
        if (!StringUtils.isEmpty((String)ticket.getAttribute("shsResolution"))) {
            MXStringType shsResolution = new MXStringType();
            shsResolution.setValue(ticket.getAttribute("shsResolution"));
            incident.setSHSRESOLUTION(shsResolution);
        }
        if (!StringUtils.isEmpty((String)ticket.getAttribute("shsRoomNumber"))) {
            MXStringType shsRoomNumber = new MXStringType();
            shsRoomNumber.setValue(ticket.getAttribute("shsRoomNumber"));
            incident.setSHSROOMNUMBER(shsRoomNumber);
        }
        if (!StringUtils.isEmpty((String)ticket.getAttribute("siteId"))) {
            MXStringType siteId = new MXStringType();
            siteId.setValue(ticket.getAttribute("siteId"));
            incident.setSITEID(siteId);
        }
        if (!StringUtils.isEmpty((String)ticket.getAttribute("source"))) {
            MXStringType source = new MXStringType();
            source.setValue(ticket.getAttribute("source"));
            incident.setSOURCE(source);
        }
        MXStringType status = new MXStringType();
        try {
            if (ticket.getState().equals((Object)Ticket.State.OPEN)) {
                status.setValue(TsrmTicketerPlugin.getProperties().getProperty("tsrm.status.open"));
            } else if (ticket.getState().equals((Object)Ticket.State.CLOSED)) {
                status.setValue(TsrmTicketerPlugin.getProperties().getProperty("tsrm.status.close"));
            }
        }
        catch (IOException e) {
            LOG.error("Unable to load tsrm.status from properties ", (Throwable)e);
        }
        incident.setSTATUS(status);
        if (!StringUtils.isEmpty((String)ticket.getAttribute("statusIface"))) {
            MXBooleanType statusIface = new MXBooleanType();
            statusIface.setValue(Boolean.parseBoolean(ticket.getAttribute("statusIface")));
            incident.setSTATUSIFACE(statusIface);
        }
    }

    private static Properties getProperties() throws IOException {
        File home = new File(System.getProperty("opennms.home"));
        File etc = new File(home, "etc");
        File config = new File(etc, "tsrm.properties");
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(config);){
            props.load(in);
        }
        catch (IOException e) {
            LOG.error("Unable to load config  {} ", (Object)config, (Object)e);
            throw new IOException("Error loading properties", e);
        }
        LOG.debug("Loaded endpointURL {} ", (Object)props.getProperty("tsrm.url").toString());
        LOG.debug("Loaded disableSSLCheck {} ", (Object)props.getProperty("tsrm.ssl.strict").toString());
        return props;
    }

    public SHSIMPINCPortType getPort() {
        return this.port;
    }

    public void setPort(SHSIMPINCPortType port) {
        this.port = port;
    }
}

