/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.Bucket;
import io.searchbox.core.search.aggregation.BucketAggregation;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class TermsAggregation
extends BucketAggregation {
    public static final String TYPE = "terms";
    private Long docCountErrorUpperBound;
    private Long sumOtherDocCount;
    private List<Entry> buckets = new LinkedList<Entry>();

    public TermsAggregation(String name, JsonObject termAggregation) {
        super(name, termAggregation);
        if (termAggregation.has(String.valueOf((Object)AggregationField.DOC_COUNT_ERROR_UPPER_BOUND))) {
            this.docCountErrorUpperBound = termAggregation.get(String.valueOf((Object)AggregationField.DOC_COUNT_ERROR_UPPER_BOUND)).getAsLong();
        }
        if (termAggregation.has(String.valueOf((Object)AggregationField.SUM_OTHER_DOC_COUNT))) {
            this.sumOtherDocCount = termAggregation.get(String.valueOf((Object)AggregationField.SUM_OTHER_DOC_COUNT)).getAsLong();
        }
        if (termAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && termAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isJsonArray()) {
            this.parseBuckets(termAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).getAsJsonArray());
        }
    }

    private void parseBuckets(JsonArray bucketsSource) {
        for (JsonElement bucketElement : bucketsSource) {
            JsonObject bucket = (JsonObject)bucketElement;
            if (bucket.has(String.valueOf((Object)AggregationField.KEY_AS_STRING))) {
                this.buckets.add(new Entry(bucket, bucket.get(String.valueOf((Object)AggregationField.KEY)).getAsString(), bucket.get(String.valueOf((Object)AggregationField.KEY_AS_STRING)).getAsString(), bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).getAsLong()));
                continue;
            }
            this.buckets.add(new Entry(bucket, bucket.get(String.valueOf((Object)AggregationField.KEY)).getAsString(), bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).getAsLong()));
        }
    }

    public Long getDocCountErrorUpperBound() {
        return this.docCountErrorUpperBound;
    }

    public Long getSumOtherDocCount() {
        return this.sumOtherDocCount;
    }

    public List<Entry> getBuckets() {
        return this.buckets;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TermsAggregation rhs = (TermsAggregation)obj;
        return super.equals(obj) && Objects.equals(this.buckets, rhs.buckets) && Objects.equals(this.docCountErrorUpperBound, rhs.docCountErrorUpperBound) && Objects.equals(this.sumOtherDocCount, rhs.sumOtherDocCount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.docCountErrorUpperBound, this.sumOtherDocCount, this.buckets);
    }

    public class Entry
    extends Bucket {
        private String key;
        private String keyAsString;

        public Entry(JsonObject bucket, String key, Long count) {
            this(bucket, key, key, count);
        }

        public Entry(JsonObject bucket, String key, String keyAsString, Long count) {
            super(bucket, count);
            this.key = key;
            this.keyAsString = keyAsString;
        }

        public String getKey() {
            return this.key;
        }

        public String getKeyAsString() {
            return this.keyAsString;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Entry rhs = (Entry)obj;
            return super.equals(obj) && Objects.equals(this.key, rhs.key) && Objects.equals(this.keyAsString, rhs.keyAsString);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getCount(), this.getKey(), this.keyAsString);
        }
    }
}

