/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.ssl.Base64;
import org.apache.commons.ssl.PEMItem;
import org.apache.commons.ssl.Util;
import org.apache.commons.ssl.util.ByteArrayReadLine;

public class PEMUtil {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static byte[] encode(Collection items) throws IOException {
        byte[] LINE_SEPARATOR_BYTES = LINE_SEPARATOR.getBytes("UTF-8");
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        for (PEMItem item : items) {
            byte[] base64Line;
            out.write("-----BEGIN ".getBytes("UTF-8"));
            out.write(item.pemType.getBytes("UTF-8"));
            out.write("-----".getBytes("UTF-8"));
            out.write(LINE_SEPARATOR_BYTES);
            byte[] derBytes = item.getDerBytes();
            ByteArrayInputStream bin = new ByteArrayInputStream(derBytes);
            byte[] line = Util.streamToBytes(bin, 48);
            while (line.length == 48) {
                base64Line = Base64.encodeBase64(line);
                out.write(base64Line);
                out.write(LINE_SEPARATOR_BYTES);
                line = Util.streamToBytes(bin, 48);
            }
            if (line.length > 0) {
                base64Line = Base64.encodeBase64(line);
                out.write(base64Line);
                out.write(LINE_SEPARATOR_BYTES);
            }
            out.write("-----END ".getBytes("UTF-8"));
            out.write(item.pemType.getBytes("UTF-8"));
            out.write("-----".getBytes("UTF-8"));
            out.write(LINE_SEPARATOR_BYTES);
        }
        return out.toByteArray();
    }

    public static List decode(byte[] pemBytes) {
        LinkedList<PEMItem> pemItems = new LinkedList<PEMItem>();
        ByteArrayInputStream in = new ByteArrayInputStream(pemBytes);
        ByteArrayReadLine readLine = new ByteArrayReadLine(in);
        String line = readLine.next();
        while (line != null) {
            int len = 0;
            ArrayList<byte[]> listOfByteArrays = new ArrayList<byte[]>(64);
            HashMap<String, String> properties = new HashMap<String, String>();
            String type = "[unknown]";
            while (line != null && !PEMUtil.beginBase64(line)) {
                line = readLine.next();
            }
            if (line != null) {
                String upperLine = line.toUpperCase();
                int x = upperLine.indexOf("-BEGIN") + "-BEGIN".length();
                int y = upperLine.indexOf("-", x);
                type = upperLine.substring(x, y).trim();
                line = readLine.next();
            }
            while (line != null && !PEMUtil.endBase64(line)) {
                if (!"".equals(line = Util.trim(line))) {
                    int x = line.indexOf(58);
                    if (x > 0) {
                        String k = line.substring(0, x).trim();
                        String v = "";
                        if (line.length() > x + 1) {
                            v = line.substring(x + 1).trim();
                        }
                        properties.put(k.toLowerCase(), v.toLowerCase());
                    } else {
                        byte[] base64 = line.getBytes();
                        byte[] rawBinary = Base64.decodeBase64(base64);
                        listOfByteArrays.add(rawBinary);
                        len += rawBinary.length;
                    }
                }
                line = readLine.next();
            }
            if (line != null) {
                line = readLine.next();
            }
            if (listOfByteArrays.isEmpty()) continue;
            byte[] decoded = new byte[len];
            int pos = 0;
            for (byte[] oneLine : listOfByteArrays) {
                System.arraycopy(oneLine, 0, decoded, pos, oneLine.length);
                pos += oneLine.length;
            }
            PEMItem item = new PEMItem(decoded, type, properties);
            pemItems.add(item);
        }
        return pemItems;
    }

    private static boolean beginBase64(String line) {
        line = line != null ? line.trim().toUpperCase() : "";
        int x = line.indexOf("-BEGIN");
        return x > 0 && PEMUtil.startsAndEndsWithDashes(line);
    }

    private static boolean endBase64(String line) {
        line = line != null ? line.trim().toUpperCase() : "";
        int x = line.indexOf("-END");
        return x > 0 && PEMUtil.startsAndEndsWithDashes(line);
    }

    private static boolean startsAndEndsWithDashes(String line) {
        line = Util.trim(line);
        char c = line.charAt(0);
        char d = line.charAt(line.length() - 1);
        return c == '-' && d == '-';
    }

    public static String formatRSAPrivateKey(RSAPrivateCrtKey key) {
        StringBuffer buf = new StringBuffer(2048);
        buf.append("Private-Key:");
        buf.append(LINE_SEPARATOR);
        buf.append("modulus:");
        buf.append(LINE_SEPARATOR);
        buf.append(PEMUtil.formatBigInteger(key.getModulus(), 258));
        buf.append(LINE_SEPARATOR);
        buf.append("publicExponent: ");
        buf.append(key.getPublicExponent());
        buf.append(LINE_SEPARATOR);
        buf.append("privateExponent:");
        buf.append(LINE_SEPARATOR);
        buf.append(PEMUtil.formatBigInteger(key.getPrivateExponent(), 256));
        buf.append(LINE_SEPARATOR);
        buf.append("prime1:");
        buf.append(LINE_SEPARATOR);
        buf.append(PEMUtil.formatBigInteger(key.getPrimeP(), 130));
        buf.append(LINE_SEPARATOR);
        buf.append("prime2:");
        buf.append(LINE_SEPARATOR);
        buf.append(PEMUtil.formatBigInteger(key.getPrimeQ(), 130));
        buf.append(LINE_SEPARATOR);
        buf.append("exponent1:");
        buf.append(LINE_SEPARATOR);
        buf.append(PEMUtil.formatBigInteger(key.getPrimeExponentP(), 130));
        buf.append(LINE_SEPARATOR);
        buf.append("exponent2:");
        buf.append(LINE_SEPARATOR);
        buf.append(PEMUtil.formatBigInteger(key.getPrimeExponentQ(), 130));
        buf.append(LINE_SEPARATOR);
        buf.append("coefficient:");
        buf.append(LINE_SEPARATOR);
        buf.append(PEMUtil.formatBigInteger(key.getCrtCoefficient(), 130));
        return buf.toString();
    }

    public static String formatBigInteger(BigInteger bi, int length) {
        int i;
        String s = bi.toString(16);
        StringBuffer buf = new StringBuffer(s.length());
        int zeroesToAppend = length - s.length();
        int count = 0;
        buf.append("    ");
        for (i = 0; i < zeroesToAppend; ++i) {
            ++count;
            buf.append('0');
            if (i % 2 != 1) continue;
            buf.append(':');
        }
        for (i = 0; i < s.length() - 2; ++i) {
            ++count;
            buf.append(s.charAt(i));
            if (i % 2 == 1) {
                buf.append(':');
            }
            if (count % 30 != 0) continue;
            buf.append(LINE_SEPARATOR);
            buf.append("    ");
        }
        buf.append(s.substring(s.length() - 2));
        return buf.toString();
    }

    public static String toPem(PublicKey key) throws IOException {
        PEMItem item = null;
        if (key instanceof RSAPublicKey) {
            item = new PEMItem(key.getEncoded(), "PUBLIC KEY");
        } else if (key instanceof DSAPublicKey) {
            item = new PEMItem(key.getEncoded(), "PUBLIC KEY");
        } else {
            throw new IOException("Not an RSA or DSA key");
        }
        byte[] pem = PEMUtil.encode(Collections.singleton(item));
        return new String(pem, "UTF-8");
    }
}

