/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.service.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.json.JSONObject;
import org.opennms.features.config.dao.api.ConfigData;
import org.opennms.features.config.dao.api.ConfigDefinition;
import org.opennms.features.config.dao.api.ConfigStoreDao;
import org.opennms.features.config.exception.ConfigAlreadyExistsException;
import org.opennms.features.config.exception.ConfigNotFoundException;
import org.opennms.features.config.exception.ConfigRuntimeException;
import org.opennms.features.config.exception.SchemaAlreadyExistsException;
import org.opennms.features.config.exception.SchemaNotFoundException;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.opennms.features.config.service.api.ConfigurationManagerService;
import org.opennms.features.config.service.api.EventType;
import org.opennms.features.config.service.api.JsonAsString;
import org.opennms.features.config.service.impl.EventHandlerManager;
import org.opennms.features.config.service.util.OpenAPIConfigHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationManagerServiceImpl
implements ConfigurationManagerService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationManagerServiceImpl.class);
    private final ConfigStoreDao<JSONObject> configStoreDao;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager();

    public ConfigurationManagerServiceImpl(ConfigStoreDao<JSONObject> configStoreDao) {
        this.configStoreDao = configStoreDao;
    }

    public void registerConfigDefinition(String configName, ConfigDefinition configDefinition) {
        Objects.requireNonNull(configName);
        Objects.requireNonNull(configDefinition);
        if (this.getRegisteredConfigDefinition(configName).isPresent()) {
            throw new SchemaAlreadyExistsException(String.format("Schema with configName=%s is already registered.", configName), null);
        }
        this.configStoreDao.register(configDefinition);
    }

    public void changeConfigDefinition(String configName, ConfigDefinition configDefinition) {
        Objects.requireNonNull(configName);
        Objects.requireNonNull(configDefinition);
        Optional<ConfigDefinition> existingDefinition = this.getRegisteredConfigDefinition(configName);
        if (existingDefinition.isEmpty()) {
            throw new SchemaNotFoundException(String.format("Schema with configName=%s is not present. Use registerSchema instead.", configName));
        }
        configDefinition.setAllowMultiple(existingDefinition.get().getAllowMultiple());
        this.configStoreDao.updateConfigDefinition(configDefinition);
    }

    public Map<String, ConfigDefinition> getAllConfigDefinitions() {
        return this.configStoreDao.getAllConfigDefinitions();
    }

    public Optional<ConfigDefinition> getRegisteredConfigDefinition(String configName) {
        Objects.requireNonNull(configName);
        return this.configStoreDao.getConfigDefinition(configName);
    }

    public void registerEventHandler(EventType type, ConfigUpdateInfo info, Consumer<ConfigUpdateInfo> consumer) {
        this.eventHandlerManager.registerEventHandler(type, info, consumer);
    }

    public void registerConfiguration(String configName, String inConfigId, JsonAsString configObject) {
        Set<String> configIds;
        Objects.requireNonNull(configName);
        Objects.requireNonNull(configObject);
        Optional<ConfigDefinition> configDefinition = this.getRegisteredConfigDefinition(configName);
        if (configDefinition.isEmpty()) {
            throw new SchemaNotFoundException(String.format("Unknown service with configName: %s.", configName));
        }
        String configId = inConfigId;
        if (configId == null) {
            configId = "default";
        }
        if ((configIds = this.getConfigIds(configName)).contains(configId)) {
            throw new ConfigAlreadyExistsException(String.format("Configuration with service=%s, id=%s is already registered, update instead.", configName, configId));
        }
        if (!configDefinition.get().getAllowMultiple()) {
            if (!"default".equals(configId)) {
                throw new ConfigRuntimeException(String.format("The '%s' service allows only one configuration with id='%s'.", configName, "default", configId));
            }
            if (!configIds.isEmpty()) {
                throw new ConfigAlreadyExistsException(String.format("The service '%s' found existing configuration(s) with id(s) other than '%s'.", configName, "default"));
            }
        }
        this.eventHandlerManager.callEventHandlers(EventType.VALIDATE, new ConfigUpdateInfo(configName, configId, new JSONObject(configObject.toString())));
        this.configStoreDao.addConfig(configName, configId, new JSONObject(configObject.toString()));
        LOG.info("ConfigurationManager.registeredConfiguration(configName={}, configId={}, config={});", new Object[]{configName, configId, configObject});
        this.eventHandlerManager.callEventHandlers(EventType.CREATE, new ConfigUpdateInfo(configName, configId));
    }

    public void unregisterConfiguration(String configName, String configId) {
        this.configStoreDao.deleteConfig(configName, configId);
        this.eventHandlerManager.callEventHandlers(EventType.DELETE, new ConfigUpdateInfo(configName, configId));
    }

    public void updateConfiguration(String configName, String configId, JsonAsString config, boolean isReplace) {
        JSONObject configToUpdate;
        Optional configData = this.configStoreDao.getConfigs(configName);
        if (configData.isEmpty()) {
            throw new ConfigNotFoundException("ConfigData not found configName: " + configName);
        }
        Map configs = ((ConfigData)configData.get()).getConfigs();
        if (!configs.containsKey(configId)) {
            throw new ConfigNotFoundException("Config not found configName: " + configName + ", configId: " + configId);
        }
        JSONObject configObject = new JSONObject(config.toString());
        if (isReplace) {
            configToUpdate = configObject;
            configs.put(configId, configToUpdate);
        } else {
            configToUpdate = (JSONObject)configs.get(configId);
            configObject.keySet().forEach(key -> configToUpdate.put(key, configObject.get(key)));
        }
        this.eventHandlerManager.callEventHandlers(EventType.VALIDATE, new ConfigUpdateInfo(configName, configId, configToUpdate));
        this.configStoreDao.updateConfigs(configName, (ConfigData)configData.get());
        this.eventHandlerManager.callEventHandlers(EventType.UPDATE, new ConfigUpdateInfo(configName, configId));
    }

    public Optional<JSONObject> getJSONConfiguration(String configName, String configId) {
        Optional configObj = this.configStoreDao.getConfig(configName, configId);
        if (configObj.isEmpty()) {
            return configObj;
        }
        Optional def = this.configStoreDao.getConfigDefinition(configName);
        if (def.isPresent()) {
            String schemaName = (String)((ConfigDefinition)def.get()).getMetaValue("topLevelElement");
            if (schemaName == null) {
                schemaName = configName;
            }
            OpenAPIConfigHelper.fillWithDefaultValue(((ConfigDefinition)def.get()).getSchema(), schemaName, (JSONObject)configObj.get());
        }
        return configObj;
    }

    public Optional<String> getJSONStrConfiguration(String configName, String configId) {
        Optional<JSONObject> config = this.getJSONConfiguration(configName, configId);
        if (config.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(config.get().toString());
    }

    public Set<String> getConfigNames() {
        return this.configStoreDao.getConfigNames();
    }

    public void unregisterSchema(String configName) {
        this.configStoreDao.unregister(configName);
    }

    public Set<String> getConfigIds(String configName) {
        Optional configData = this.configStoreDao.getConfigs(configName);
        if (configData.isEmpty()) {
            return new HashSet<String>();
        }
        return ((ConfigData)configData.get()).getConfigs().keySet();
    }

    public Optional<ConfigData<JSONObject>> getConfigData(String configName) {
        return this.configStoreDao.getConfigs(configName);
    }
}

