/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.datachoices.web.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.opennms.features.datachoices.internal.StateManager;
import org.opennms.features.datachoices.internal.productupdateenrollment.ProductUpdateEnrollmentFormData;
import org.opennms.features.datachoices.internal.productupdateenrollment.ProductUpdateEnrollmentService;
import org.opennms.features.datachoices.internal.productupdateenrollment.ProductUpdateEnrollmentStatusDTO;
import org.opennms.features.datachoices.internal.usagestatistics.UsageStatisticsMetadataDTO;
import org.opennms.features.datachoices.internal.usagestatistics.UsageStatisticsReportDTO;
import org.opennms.features.datachoices.internal.usagestatistics.UsageStatisticsReporter;
import org.opennms.features.datachoices.internal.usagestatistics.UsageStatisticsStatusDTO;
import org.opennms.features.datachoices.web.DataChoiceRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChoiceRestServiceImpl
implements DataChoiceRestService {
    private static final Logger LOG = LoggerFactory.getLogger(DataChoiceRestServiceImpl.class);
    private StateManager m_stateManager;
    private UsageStatisticsReporter m_usageStatisticsReporter;
    private ProductUpdateEnrollmentService productUpdateEnrollmentService;
    private static final String METADATA_RESOURCE_PATH = "web/datachoicesMetadata.json";

    @Override
    public UsageStatisticsReportDTO getUsageStatistics() throws ServletException, IOException {
        return this.m_usageStatisticsReporter.generateReport();
    }

    @Override
    public Response getStatus() throws ServletException, IOException {
        UsageStatisticsStatusDTO dto = new UsageStatisticsStatusDTO();
        try {
            dto.setEnabled(this.m_stateManager.isEnabled());
            dto.setInitialNoticeAcknowledged(this.m_stateManager.isInitialNoticeAcknowledged());
        }
        catch (Exception e) {
            return this.getExceptionResponse("Error getting Usage Statistics status.", e);
        }
        return Response.ok((Object)dto).build();
    }

    @Override
    public Response setStatus(HttpServletRequest request, UsageStatisticsStatusDTO dto) throws ServletException, IOException {
        try {
            String remoteUser = request.getRemoteUser();
            if (dto.getEnabled() != null) {
                this.m_stateManager.setEnabled(dto.getEnabled(), remoteUser);
            }
            if (dto.getInitialNoticeAcknowledged() != null) {
                this.m_stateManager.setInitialNoticeAcknowledged(dto.getInitialNoticeAcknowledged(), remoteUser);
            }
        }
        catch (Exception e) {
            return this.getExceptionResponse("Error setting Usage Statistics status.", e);
        }
        return Response.accepted().build();
    }

    @Override
    public Response getProductUpdateEnrollmentStatus() throws ServletException, IOException {
        ProductUpdateEnrollmentStatusDTO dto = new ProductUpdateEnrollmentStatusDTO();
        try {
            dto.setNoticeAcknowledged(this.m_stateManager.isProductUpdateEnrollmentNoticeAcknowledged());
            dto.setOptedIn(this.m_stateManager.isProductUpdateEnrollmentOptedIn());
        }
        catch (Exception e) {
            return this.getExceptionResponse("Error getting Product Update Enrollment status.", e);
        }
        return Response.ok((Object)dto).build();
    }

    @Override
    public Response setProductUpdateEnrollmentStatu(HttpServletRequest request, ProductUpdateEnrollmentStatusDTO dto) throws ServletException, IOException {
        try {
            String remoteUser = request.getRemoteUser();
            if (dto.getOptedIn() != null) {
                this.m_stateManager.setProductUpdateEnrollmentOptedIn(dto.getOptedIn());
            }
            if (dto.getNoticeAcknowledged() != null) {
                this.m_stateManager.setProductUpdateEnrollmentNoticeAcknowledged(dto.getNoticeAcknowledged(), remoteUser);
            }
        }
        catch (Exception e) {
            return this.getExceptionResponse("Error setting Product Update Enrollment status.", e);
        }
        return Response.accepted().build();
    }

    @Override
    public Response getMetadata() {
        UsageStatisticsMetadataDTO dto = null;
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(METADATA_RESOURCE_PATH);){
            ObjectMapper mapper = new ObjectMapper();
            dto = (UsageStatisticsMetadataDTO)mapper.readValue(inputStream, UsageStatisticsMetadataDTO.class);
        }
        catch (Exception e) {
            return this.getExceptionResponse("Error getting Usage Statistics metadata.", e);
        }
        return Response.ok((Object)dto).build();
    }

    @Override
    public Response submitProductUpdateEnrollmentData(HttpServletRequest request, ProductUpdateEnrollmentFormData data) throws ServletException, IOException {
        String show = System.getProperty("opennms.productUpdateEnrollment.show", "true");
        if (show != null && show.equalsIgnoreCase("false")) {
            String msg = "Product Update Enrollment has been disabled by the 'opennms.productUpdateEnrollment.show' configuration point.";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)msg).build();
        }
        try {
            this.productUpdateEnrollmentService.submit(data);
        }
        catch (Exception e) {
            return this.getExceptionResponse("Error submitting Product Update Enrollment form data.", e);
        }
        return Response.accepted().build();
    }

    public void setStateManager(StateManager stateManager) {
        this.m_stateManager = stateManager;
    }

    public void setUsageStatisticsReporter(UsageStatisticsReporter usageStatisticsReporter) {
        this.m_usageStatisticsReporter = Objects.requireNonNull(usageStatisticsReporter);
    }

    public void setProductUpdateEnrollmentService(ProductUpdateEnrollmentService service) {
        this.productUpdateEnrollmentService = service;
    }

    private Response getExceptionResponse(String msg, Throwable e) {
        LOG.error(msg, e);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)msg).build();
    }
}

