/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.datachoices.internal.productupdateenrollment;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductUpdateEnrollmentSubmissionClient {
    private static final Logger LOG = LoggerFactory.getLogger(ProductUpdateEnrollmentSubmissionClient.class);
    private String endpointUrl;

    public void postForm(String json) throws Exception, IOException, InterruptedException {
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(10L)).build();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.endpointUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).setHeader("User-Agent", "OpenNMS Product Update Enrollment").build();
        LOG.info("Sending Product Update Enrollment submission form data to: {}", (Object)this.endpointUrl);
        HttpResponse<String> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            LOG.error("Received error response from submission endpoint. Status code: {}. Body: {}.", (Object)response.statusCode(), (Object)response.body());
            throw new Exception("Received error response from submission endpoint.");
        }
        LOG.info("Product Update Enrollment submission accepted.");
    }

    public void setEndpointUrl(String url) {
        this.endpointUrl = url;
    }
}

