/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.datachoices.internal;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.opennms.features.config.service.api.ConfigurationManagerService;
import org.opennms.features.config.service.util.CmProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateManager {
    private static final Logger LOG = LoggerFactory.getLogger(StateManager.class);
    private static final String PROPERTIES_CONFIG_NAME = "org.opennms.features.datachoices";
    private static final String ENABLED_KEY = "enabled";
    private static final String SYSTEM_ID_KEY = "systemid";
    private static final String ACKNOWLEDGED_BY_KEY = "acknowledged-by";
    private static final String ACKNOWLEDGED_AT_KEY = "acknowledged-at";
    private static final String INITIAL_NOTICE_ACKNOWLEDGED_KEY = "initialNoticeAcknowledged";
    private static final String INITIAL_NOTICE_ACKNOWLEDGED_AT_KEY = "initialNoticeAcknowledgedAt";
    private static final String INITIAL_NOTICE_ACKNOWLEDGED_BY_KEY = "initialNoticeAcknowledgedBy";
    private static final String PRODUCT_UPDATE_ENROLLMENT_OPTED_IN_KEY = "userDataCollectionOptedIn";
    private static final String PRODUCT_UPDATE_ENROLLMENT_NOTICE_ACKNOWLEDGED_KEY = "userDataCollectionNoticeAcknowledged";
    private static final String PRODUCT_UPDATE_ENROLLMENT_NOTICE_ACKNOWLEDGED_AT_KEY = "userDataCollectionNoticeAcknowledgedAt";
    private static final String PRODUCT_UPDATE_ENROLLMENT_NOTICE_ACKNOWLEDGED_BY_KEY = "userDataCollectionNoticeAcknowledgedBy";
    private final List<StateChangeHandler> m_listeners = Lists.newArrayList();
    private final CmProperties propertiesCache;

    public StateManager(ConfigurationManagerService cm) {
        ConfigUpdateInfo configIdentifier = new ConfigUpdateInfo(PROPERTIES_CONFIG_NAME, "default");
        this.propertiesCache = new CmProperties(cm, configIdentifier);
    }

    public Boolean isEnabled() throws IOException {
        return (Boolean)this.propertiesCache.getProperty(ENABLED_KEY);
    }

    public void setEnabled(boolean enabled, String user) throws Exception {
        this.propertiesCache.setProperty(ENABLED_KEY, (Object)enabled);
        this.propertiesCache.setProperty(ACKNOWLEDGED_BY_KEY, (Object)(user == null ? "" : user));
        this.propertiesCache.setProperty(ACKNOWLEDGED_AT_KEY, (Object)new Date().toString());
        for (StateChangeHandler listener : this.m_listeners) {
            listener.onIsEnabledChanged(enabled);
        }
    }

    public Boolean isInitialNoticeAcknowledged() throws IOException {
        return (Boolean)this.propertiesCache.getProperty(INITIAL_NOTICE_ACKNOWLEDGED_KEY);
    }

    public void setInitialNoticeAcknowledged(boolean status, String user) throws Exception {
        this.propertiesCache.setProperty(INITIAL_NOTICE_ACKNOWLEDGED_KEY, (Object)status);
        this.propertiesCache.setProperty(INITIAL_NOTICE_ACKNOWLEDGED_BY_KEY, (Object)(user == null ? "" : user));
        this.propertiesCache.setProperty(INITIAL_NOTICE_ACKNOWLEDGED_AT_KEY, (Object)new Date().toString());
    }

    public Boolean isProductUpdateEnrollmentNoticeAcknowledged() throws IOException {
        return (Boolean)this.propertiesCache.getProperty(PRODUCT_UPDATE_ENROLLMENT_NOTICE_ACKNOWLEDGED_KEY);
    }

    public void setProductUpdateEnrollmentNoticeAcknowledged(boolean status, String user) throws Exception {
        this.propertiesCache.setProperty(PRODUCT_UPDATE_ENROLLMENT_NOTICE_ACKNOWLEDGED_KEY, (Object)status);
        this.propertiesCache.setProperty(PRODUCT_UPDATE_ENROLLMENT_NOTICE_ACKNOWLEDGED_BY_KEY, (Object)(user == null ? "" : user));
        this.propertiesCache.setProperty(PRODUCT_UPDATE_ENROLLMENT_NOTICE_ACKNOWLEDGED_AT_KEY, (Object)new Date().toString());
    }

    public Boolean isProductUpdateEnrollmentOptedIn() throws IOException {
        return (Boolean)this.propertiesCache.getProperty(PRODUCT_UPDATE_ENROLLMENT_OPTED_IN_KEY);
    }

    public void setProductUpdateEnrollmentOptedIn(boolean status) throws Exception {
        this.propertiesCache.setProperty(PRODUCT_UPDATE_ENROLLMENT_OPTED_IN_KEY, (Object)status);
    }

    public String getOrGenerateSystemId() throws IOException {
        String systemId = (String)this.propertiesCache.getProperty(SYSTEM_ID_KEY);
        if (systemId == null) {
            LOG.debug("No existing system id was found. Generating a new system id.");
            systemId = UUID.randomUUID().toString();
            this.propertiesCache.setProperty(SYSTEM_ID_KEY, (Object)systemId);
        }
        return systemId;
    }

    public String getAndRegenerateSystemId() throws IOException {
        String systemId = UUID.randomUUID().toString();
        this.propertiesCache.setProperty(SYSTEM_ID_KEY, (Object)systemId);
        return systemId;
    }

    public void onIsEnabledChanged(StateChangeHandler callback) {
        this.m_listeners.add(Objects.requireNonNull(callback));
    }

    public static interface StateChangeHandler {
        public void onIsEnabledChanged(boolean var1);
    }
}

