/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.json.ValueFaultHandler;
import org.jolokia.converter.object.StringToObjectConverter;
import org.jolokia.shaded.org.json.simple.JSONArray;

public class CollectionExtractor
implements Extractor {
    @Override
    public Class getType() {
        return Collection.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pPathParts, boolean jsonify) throws AttributeNotFoundException {
        Collection collection = (Collection)pValue;
        String pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        int length = pConverter.getCollectionLength(collection.size());
        if (pathPart != null) {
            return this.extractWithPath(pConverter, collection, pPathParts, jsonify, pathPart, length);
        }
        return jsonify ? this.extractListAsJson(pConverter, collection, pPathParts, length) : collection;
    }

    private Object extractWithPath(ObjectToJsonConverter pConverter, Collection pCollection, Stack<String> pPathParts, boolean pJsonify, String pPathPart, int pLength) throws AttributeNotFoundException {
        try {
            int idx = Integer.parseInt(pPathPart);
            return pConverter.extractObject(this.getElement(pCollection, idx, pLength), pPathParts, pJsonify);
        }
        catch (NumberFormatException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException(new AttributeNotFoundException("Index '" + pPathPart + "' is not numeric for accessing list"));
        }
        catch (IndexOutOfBoundsException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException(new AttributeNotFoundException("Index '" + pPathPart + "' is out-of-bound for a list of size " + pLength));
        }
    }

    private Object getElement(Collection pCollection, int pIdx, int pLength) {
        Iterator it = pCollection.iterator();
        for (int i = 0; it.hasNext() && i < pLength; ++i) {
            Object val = it.next();
            if (i != pIdx) continue;
            return val;
        }
        throw new IndexOutOfBoundsException("Collection index " + pIdx + " larger than size " + pLength);
    }

    private Object extractListAsJson(ObjectToJsonConverter pConverter, Collection pCollection, Stack<String> pPathParts, int pLength) throws AttributeNotFoundException {
        JSONArray ret = new JSONArray();
        Iterator it = pCollection.iterator();
        for (int i = 0; i < pLength; ++i) {
            Object val = it.next();
            Stack path = (Stack)pPathParts.clone();
            ret.add(pConverter.extractObject(val, path, true));
        }
        return ret;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("A collection (beside Lists and Maps) cannot be modified");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

