/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.buffer;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.ByteNotFoundException;
import io.pkts.buffer.WriteNotSupportedException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class EmptyBuffer
implements Buffer {
    private static final String THIS_IS_AN_EMPTY_BUFFER_CANT_WRITE_TO_IT = "This is an empty buffer. Cant write to it";
    private static final String THIS_BUFFER_IS_EMPTY = "This buffer is empty";
    private static final String NOT_ENOUGH_READABLE_BYTES = "Not enough readable bytes";
    private static final byte[] EMPTY = new byte[0];

    protected EmptyBuffer() {
    }

    @Override
    public Buffer readBytes(int length) throws IndexOutOfBoundsException, IOException {
        if (length == 0) {
            return this;
        }
        throw new IndexOutOfBoundsException(NOT_ENOUGH_READABLE_BYTES);
    }

    @Override
    public Buffer readLine() throws IOException {
        throw new IndexOutOfBoundsException(NOT_ENOUGH_READABLE_BYTES);
    }

    @Override
    public Buffer readUntilSingleCRLF() throws IOException {
        throw new IndexOutOfBoundsException(NOT_ENOUGH_READABLE_BYTES);
    }

    @Override
    public Buffer readUntilDoubleCRLF() throws IOException {
        throw new IndexOutOfBoundsException(NOT_ENOUGH_READABLE_BYTES);
    }

    @Override
    public int getReadableBytes() {
        return 0;
    }

    @Override
    public boolean hasReadableBytes() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public byte[] getArray() {
        return EMPTY;
    }

    @Override
    public Buffer readUntil(byte b) throws IOException, ByteNotFoundException {
        throw new ByteNotFoundException(b);
    }

    @Override
    public Buffer slice(int start, int stop) {
        if (start != 0 && stop != 0) {
            throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
        }
        return this;
    }

    @Override
    public Buffer slice(int stop) {
        if (stop != 0) {
            throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
        }
        return this;
    }

    @Override
    public Buffer slice() {
        return this;
    }

    @Override
    public int getLowerBoundary() {
        return 0;
    }

    @Override
    public int getUpperBoundary() {
        return 0;
    }

    @Override
    public int getReaderIndex() {
        return 0;
    }

    @Override
    public void markReaderIndex() {
    }

    @Override
    public void resetReaderIndex() {
    }

    @Override
    public int capacity() {
        return 0;
    }

    @Override
    public byte getByte(int index) throws IndexOutOfBoundsException, IOException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public byte readByte() throws IndexOutOfBoundsException, IOException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public long readUnsignedInt() throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public int readInt() throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public int getInt(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public short getShort(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public int readUnsignedShort() throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public int getUnsignedShort(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public short readShort() throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public short readUnsignedByte() throws IndexOutOfBoundsException, IOException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public long getUnsignedInt(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public short getUnsignedByte(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public String dumpAsHex() {
        return "";
    }

    @Override
    public void setByte(int index, byte value) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public void setUnsignedByte(int index, short value) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public void setUnsignedShort(int index, int value) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public Buffer clone() {
        return this;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public byte peekByte() throws IndexOutOfBoundsException, IOException {
        throw new IndexOutOfBoundsException(NOT_ENOUGH_READABLE_BYTES);
    }

    @Override
    public Buffer readUntil(int maxBytes, byte ... bytes) throws IOException, ByteNotFoundException {
        if (bytes.length == 0) {
            return this;
        }
        throw new ByteNotFoundException(bytes[0]);
    }

    @Override
    public Buffer readUntilSafe(int maxBytes, byte ... bytes) throws IOException, IllegalArgumentException {
        if (bytes.length == 0) {
            return this;
        }
        throw new ByteNotFoundException(bytes[0]);
    }

    @Override
    public int indexOf(int maxBytes, byte ... bytes) throws IOException, ByteNotFoundException, IllegalArgumentException {
        return -1;
    }

    @Override
    public int indexOf(byte b) throws IOException, ByteNotFoundException, IllegalArgumentException {
        return -1;
    }

    @Override
    public void setReaderIndex(int index) {
    }

    @Override
    public void write(byte b) throws IndexOutOfBoundsException {
        throw new WriteNotSupportedException(THIS_IS_AN_EMPTY_BUFFER_CANT_WRITE_TO_IT);
    }

    @Override
    public void write(byte[] bytes) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(THIS_IS_AN_EMPTY_BUFFER_CANT_WRITE_TO_IT);
    }

    @Override
    public void write(String s) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(THIS_IS_AN_EMPTY_BUFFER_CANT_WRITE_TO_IT);
    }

    @Override
    public void write(String s, String charset) throws IndexOutOfBoundsException, WriteNotSupportedException, UnsupportedEncodingException {
        throw new WriteNotSupportedException(THIS_IS_AN_EMPTY_BUFFER_CANT_WRITE_TO_IT);
    }

    @Override
    public void write(int value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(THIS_IS_AN_EMPTY_BUFFER_CANT_WRITE_TO_IT);
    }

    @Override
    public void write(long value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(THIS_IS_AN_EMPTY_BUFFER_CANT_WRITE_TO_IT);
    }

    @Override
    public void writeAsString(int value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(THIS_IS_AN_EMPTY_BUFFER_CANT_WRITE_TO_IT);
    }

    @Override
    public void writeAsString(long value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(THIS_IS_AN_EMPTY_BUFFER_CANT_WRITE_TO_IT);
    }

    @Override
    public int getWriterIndex() {
        return -1;
    }

    @Override
    public void setWriterIndex(int index) {
        throw new WriteNotSupportedException(THIS_IS_AN_EMPTY_BUFFER_CANT_WRITE_TO_IT);
    }

    @Override
    public int getWritableBytes() {
        return 0;
    }

    @Override
    public boolean hasWritableBytes() {
        return false;
    }

    @Override
    public void getBytes(Buffer dst) {
    }

    @Override
    public void getBytes(byte[] dst) throws IndexOutOfBoundsException {
    }

    @Override
    public void getBytes(int index, Buffer dst) throws IndexOutOfBoundsException {
    }

    @Override
    public boolean hasWriteSupport() {
        return false;
    }

    @Override
    public void setInt(int index, int value) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("Sorry, this buffer is empty");
    }

    @Override
    public int parseToInt() throws NumberFormatException {
        throw new NumberFormatException("This buffer is empty and therefore cannot be parsed as an integer");
    }

    @Override
    public int parseToInt(int radix) {
        throw new NumberFormatException("This buffer is empty and therefore cannot be parsed as an integer");
    }

    @Override
    public void setUnsignedInt(int index, long value) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(THIS_BUFFER_IS_EMPTY);
    }

    @Override
    public boolean equalsIgnoreCase(Object other) {
        if (this == other) {
            return true;
        }
        try {
            return ((Buffer)other).isEmpty();
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }
}

