/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.buffer;

import io.pkts.buffer.BufferException;
import java.util.Arrays;

public class ByteNotFoundException
extends BufferException {
    private static final long serialVersionUID = 1L;
    private final byte[] bytes;

    public ByteNotFoundException(byte b) {
        super("Unable to locate byte " + b);
        this.bytes = new byte[]{b};
    }

    public ByteNotFoundException(byte ... bytes) {
        super("Unable to locate any of the bytes " + Arrays.toString(bytes));
        this.bytes = bytes;
    }

    public ByteNotFoundException(int maxBytes, byte ... bytes) {
        super("Gave up looking after reading " + maxBytes + " bytes. You asked me to find any of the following bytes: " + Arrays.toString(bytes));
        this.bytes = bytes;
    }

    public byte getByte() {
        return this.bytes[0];
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

