/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.core;

import java.util.ArrayList;
import java.util.Date;
import org.apache.karaf.scheduler.Job;
import org.apache.karaf.scheduler.Scheduler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhiteboardHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Scheduler scheduler;
    private ServiceTracker<?, ?> serviceTracker;

    public WhiteboardHandler(final BundleContext context, Scheduler scheduler) throws InvalidSyntaxException {
        this.scheduler = scheduler;
        this.serviceTracker = new ServiceTracker(context, context.createFilter("(|(objectClass=" + Runnable.class.getName() + ")(" + "objectClass" + "=" + Job.class.getName() + "))"), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){

            public synchronized void removedService(ServiceReference reference, Object service) {
                context.ungetService(reference);
                WhiteboardHandler.this.unregister(reference, service);
            }

            public synchronized void modifiedService(ServiceReference reference, Object service) {
                WhiteboardHandler.this.unregister(reference, service);
                WhiteboardHandler.this.register(reference, service);
            }

            public synchronized Object addingService(ServiceReference reference) {
                Object obj = context.getService(reference);
                if (obj != null) {
                    WhiteboardHandler.this.register(reference, obj);
                }
                return obj;
            }
        });
        this.serviceTracker.open();
    }

    public void deactivate() {
        this.serviceTracker.close();
    }

    private String getServiceIdentifier(ServiceReference ref) {
        String name = (String)ref.getProperty("scheduler.name");
        if (name == null) {
            if (ref.getProperty("service.pid") instanceof String) {
                name = (String)ref.getProperty("service.pid");
            } else if (ref.getProperty("service.pid") instanceof ArrayList && ((ArrayList)ref.getProperty("service.pid")).size() > 0) {
                name = ((ArrayList)ref.getProperty("service.pid")).get(0).toString();
            }
            if (name == null) {
                name = "Registered Service";
            }
        }
        name = name + "." + ref.getProperty("service.id");
        return name;
    }

    private void register(ServiceReference ref, Object job) {
        String name = this.getServiceIdentifier(ref);
        Boolean concurrent = true;
        if (ref.getProperty("scheduler.concurrent") != null) {
            concurrent = ref.getProperty("scheduler.concurrent") instanceof Boolean ? (Boolean)ref.getProperty("scheduler.concurrent") : Boolean.valueOf((String)ref.getProperty("scheduler.concurrent"));
        }
        String expression = (String)ref.getProperty("scheduler.expression");
        try {
            if (expression != null) {
                this.scheduler.schedule(job, this.scheduler.EXPR(expression).name(name).canRunConcurrently(concurrent));
            } else {
                Integer times = -1;
                Object v = ref.getProperty("scheduler.times");
                if (null != v) {
                    times = v instanceof Integer ? (Integer)v : (v instanceof Long ? Integer.valueOf(((Long)v).intValue()) : (v instanceof Number ? Integer.valueOf(((Number)v).intValue()) : Integer.valueOf(v.toString())));
                }
                Long period = null;
                if (ref.getProperty("scheduler.period") != null) {
                    period = ref.getProperty("scheduler.period") instanceof Long ? (Long)ref.getProperty("scheduler.period") : Long.valueOf((String)ref.getProperty("scheduler.period"));
                    if (period < 1L) {
                        this.logger.debug("Ignoring service {} : scheduler period is less than 1.", (Object)ref);
                    } else if (times < -1) {
                        this.logger.debug("Ignoring service {} : scheduler times is defined but is less than -1.", (Object)ref);
                    } else {
                        boolean immediate = false;
                        if (ref.getProperty("scheduler.immediate") != null) {
                            immediate = ref.getProperty("scheduler.immediate") instanceof Boolean ? ((Boolean)ref.getProperty("scheduler.immediate")).booleanValue() : Boolean.valueOf((String)ref.getProperty("scheduler.immediate")).booleanValue();
                        }
                        Date date = new Date();
                        if (!immediate) {
                            date.setTime(System.currentTimeMillis() + period * 1000L);
                        }
                        this.scheduler.schedule(job, this.scheduler.AT(date, times, period).name(name).canRunConcurrently(concurrent != null ? concurrent : true));
                    }
                } else {
                    this.logger.debug("Ignoring service {} : no scheduling property found.", (Object)ref);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Error scheduling job", (Throwable)e);
        }
    }

    private void unregister(ServiceReference reference, Object service) {
        String name = this.getServiceIdentifier(reference);
        this.scheduler.unschedule(name);
    }
}

