/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.kscReports;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.kscReports.Report;

@XmlRootElement(name="ReportsList")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="ksc-performance-reports.xsd")
public class ReportsList
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Comparator<Report> SORT_REPORTS = new Comparator<Report>(){

        @Override
        public int compare(Report o1, Report o2) {
            return o1.getTitle().compareTo(o2.getTitle());
        }
    };
    @XmlElement(name="Report")
    private List<Report> m_reports = new ArrayList<Report>();

    public List<Report> getReports() {
        return this.m_reports;
    }

    public void setReports(List<Report> reports) {
        if (reports == this.m_reports) {
            return;
        }
        this.m_reports.clear();
        if (reports != null) {
            this.m_reports.addAll(reports);
        }
        this.m_reports.sort(SORT_REPORTS);
    }

    public void addReport(Report report) {
        this.m_reports.add(report);
    }

    public void setReport(int index, Report report) {
        this.m_reports.set(index, report);
    }

    public boolean removeReport(Report report) {
        return this.m_reports.remove(report);
    }

    public void sort() {
        this.m_reports.sort(SORT_REPORTS);
    }

    public int hashCode() {
        return Objects.hash(this.m_reports);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReportsList) {
            ReportsList that = (ReportsList)obj;
            return Objects.equals(this.m_reports, that.m_reports);
        }
        return false;
    }
}

