/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.groups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.groups.Schedule;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="role")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="groups.xsd")
public class Role
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="membership-group", required=true)
    private String m_membershipGroup;
    @XmlAttribute(name="supervisor", required=true)
    private String m_supervisor;
    @XmlAttribute(name="description")
    private String m_description;
    @XmlElement(name="schedule")
    private List<Schedule> m_schedules = new ArrayList<Schedule>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getMembershipGroup() {
        return this.m_membershipGroup;
    }

    public void setMembershipGroup(String membershipGroup) {
        this.m_membershipGroup = ConfigUtils.assertNotEmpty(membershipGroup, "membership-group");
    }

    public String getSupervisor() {
        return this.m_supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.m_supervisor = ConfigUtils.assertNotEmpty(supervisor, "supervisor");
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.m_description);
    }

    public void setDescription(String description) {
        this.m_description = ConfigUtils.normalizeString(description);
    }

    public List<Schedule> getSchedules() {
        return this.m_schedules;
    }

    public void setSchedules(List<Schedule> schedules) {
        if (schedules == this.m_schedules) {
            return;
        }
        this.m_schedules.clear();
        if (schedules != null) {
            this.m_schedules.addAll(schedules);
        }
    }

    public void addSchedule(Schedule schedule) {
        this.m_schedules.add(schedule);
    }

    public void clearSchedules() {
        this.m_schedules.clear();
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_membershipGroup, this.m_supervisor, this.m_description, this.m_schedules);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Role) {
            Role that = (Role)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_membershipGroup, that.m_membershipGroup) && Objects.equals(this.m_supervisor, that.m_supervisor) && Objects.equals(this.m_description, that.m_description) && Objects.equals(this.m_schedules, that.m_schedules);
        }
        return false;
    }
}

