/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.filter.Alias;
import org.opennms.netmgt.config.filter.Constraint;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="column")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="database-schema.xsd")
public class Column
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_VISISBLE = "true";
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="sql-type")
    private String m_sqlType;
    @XmlAttribute(name="java-type")
    private String m_javaType;
    @XmlAttribute(name="visible")
    private String m_visible;
    @XmlElement(name="alias")
    private List<Alias> m_aliases = new ArrayList<Alias>();
    @XmlElement(name="constraint")
    private List<Constraint> m_constraints = new ArrayList<Constraint>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Optional<String> getSqlType() {
        return Optional.ofNullable(this.m_sqlType);
    }

    public void setSqlType(String sqlType) {
        this.m_sqlType = ConfigUtils.normalizeString(sqlType);
    }

    public Optional<String> getJavaType() {
        return Optional.ofNullable(this.m_javaType);
    }

    public void setJavaType(String javaType) {
        this.m_javaType = ConfigUtils.normalizeString(javaType);
    }

    public String getVisible() {
        return this.m_visible != null ? this.m_visible : DEFAULT_VISISBLE;
    }

    public void setVisible(String visible) {
        this.m_visible = ConfigUtils.normalizeString(visible);
    }

    public List<Alias> getAliases() {
        return this.m_aliases;
    }

    public void setAliases(List<Alias> aliases) {
        if (aliases == this.m_aliases) {
            return;
        }
        this.m_aliases.clear();
        if (aliases != null) {
            this.m_aliases.addAll(aliases);
        }
    }

    public void addAlias(Alias alias) {
        this.m_aliases.add(alias);
    }

    public boolean removeAlias(Alias alias) {
        return this.m_aliases.remove(alias);
    }

    public List<Constraint> getConstraints() {
        return this.m_constraints;
    }

    public void setConstraints(List<Constraint> constraints) {
        if (constraints == this.m_constraints) {
            return;
        }
        this.m_constraints.clear();
        if (constraints != null) {
            this.m_constraints.addAll(constraints);
        }
    }

    public void addConstraint(Constraint constraint) {
        this.m_constraints.add(constraint);
    }

    public boolean removeConstraint(Constraint constraint) {
        return this.m_constraints.remove(constraint);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_sqlType, this.m_javaType, this.m_visible, this.m_aliases, this.m_constraints);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Column) {
            Column that = (Column)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_sqlType, that.m_sqlType) && Objects.equals(this.m_javaType, that.m_javaType) && Objects.equals(this.m_visible, that.m_visible) && Objects.equals(this.m_aliases, that.m_aliases) && Objects.equals(this.m_constraints, that.m_constraints);
        }
        return false;
    }
}

