/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.discovery;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="include-range")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="discovery-configuration.xsd")
public class IncludeRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="location")
    private String location;
    @XmlAttribute(name="retries")
    private Integer retries;
    @XmlAttribute(name="timeout")
    private Long timeout;
    @XmlAttribute(name="foreign-source")
    private String foreignSource;
    @XmlElement(name="begin", required=true)
    private String begin;
    @XmlElement(name="end", required=true)
    private String end;

    public IncludeRange() {
    }

    public IncludeRange(String begin, String end) {
        this.setBegin(begin);
        this.setEnd(end);
    }

    public Optional<String> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public void setLocation(String location) {
        this.location = ConfigUtils.normalizeString(location);
    }

    public Optional<Integer> getRetries() {
        return Optional.ofNullable(this.retries);
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public void setTimeout(Long timeout) {
        if (timeout != null && timeout == 0L) {
            throw new IllegalArgumentException("Can't have a 0 timeout!");
        }
        this.timeout = timeout;
    }

    public Optional<String> getForeignSource() {
        return Optional.ofNullable(this.foreignSource);
    }

    public void setForeignSource(String foreignSource) {
        this.foreignSource = ConfigUtils.normalizeString(foreignSource);
    }

    public String getBegin() {
        return this.begin;
    }

    public void setBegin(String begin) {
        this.begin = ConfigUtils.assertNotEmpty(begin, "begin");
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = ConfigUtils.assertNotEmpty(end, "end");
    }

    public int hashCode() {
        return Objects.hash(this.location, this.retries, this.timeout, this.foreignSource, this.begin, this.end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IncludeRange) {
            IncludeRange temp = (IncludeRange)obj;
            return Objects.equals(temp.location, this.location) && Objects.equals(temp.retries, this.retries) && Objects.equals(temp.timeout, this.timeout) && Objects.equals(temp.foreignSource, this.foreignSource) && Objects.equals(temp.begin, this.begin) && Objects.equals(temp.end, this.end);
        }
        return false;
    }

    public String toString() {
        return "IncludeRange [location=" + this.location + ", retries=" + this.retries + ", timeout=" + this.timeout + ", foreignSource=" + this.foreignSource + ", begin=" + this.begin + ", end=" + this.end + "]";
    }
}

