/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jna;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.opennms.core.tracker.ResponseWithId;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.jna.JnaPingRequestId;

public final class JnaPingReply
implements ResponseWithId<JnaPingRequestId>,
EchoPacket {
    private final InetAddress m_address;
    private final EchoPacket m_packet;

    public JnaPingReply(InetAddress addr, EchoPacket pkt) {
        this.m_address = addr;
        this.m_packet = pkt;
    }

    public JnaPingRequestId getRequestId() {
        return new JnaPingRequestId(this.getAddress(), this.getIdentifier(), this.getSequenceNumber(), this.getThreadId());
    }

    public final InetAddress getAddress() {
        return this.m_address;
    }

    public boolean isEchoReply() {
        return this.m_packet.isEchoReply();
    }

    public int getIdentifier() {
        return this.m_packet.getIdentifier();
    }

    public int getSequenceNumber() {
        return this.m_packet.getSequenceNumber();
    }

    public long getThreadId() {
        return this.m_packet.getThreadId();
    }

    public long getReceivedTimeNanos() {
        return this.m_packet.getReceivedTimeNanos();
    }

    public long getSentTimeNanos() {
        return this.m_packet.getSentTimeNanos();
    }

    public double elapsedTime(TimeUnit timeUnit) {
        return this.m_packet.elapsedTime(timeUnit);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append('[');
        buf.append("Address = ").append(this.getAddress());
        buf.append(", ");
        buf.append("JnaPingRequestId = ").append(this.getRequestId().toString());
        buf.append(']');
        return buf.toString();
    }
}

