/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.spring.web;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.spring.web.ServiceRegistryHttpInvokerProxyFactoryBean;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;
import org.springframework.web.util.NestedServletException;

public class ServiceRegistryHttpInvokerServiceExporter
extends HttpInvokerServiceExporter {
    private ServiceRegistry serviceRegistry;

    public ServiceRegistryHttpInvokerServiceExporter() {
        super.setServiceInterface(ServiceRegistry.class);
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setService((Object)serviceRegistry);
        this.serviceRegistry = serviceRegistry;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            RemoteInvocation invocation = this.readRemoteInvocation(request);
            Serializable interfaceNameObject = invocation.getAttribute(ServiceRegistryHttpInvokerProxyFactoryBean.ATTRIBUTE_INTERFACE_NAME);
            if (interfaceNameObject == null) {
                throw new NestedServletException("Interface name attribute not found. This class can only service requests to a " + ServiceRegistryHttpInvokerProxyFactoryBean.class.getSimpleName() + " client.");
            }
            String interfaceName = (String)((Object)interfaceNameObject);
            try {
                RemoteInvocationResult result = this.invokeAndCreateResult(invocation, this.serviceRegistry.findProvider(Class.forName(interfaceName)));
                this.writeRemoteInvocationResult(request, response, result);
            }
            catch (IllegalArgumentException e) {
                throw new NestedServletException("No provider registered for interface " + interfaceName, (Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new NestedServletException("Class not found during deserialization", (Throwable)e);
        }
    }
}

