/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.InsufficientParametersException;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.support.Ssh;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SshMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(SshMonitor.class);
    private static final int DEFAULT_RETRY = 0;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_PORT = 22;

    public PollStatus poll(InetAddress address, Map<String, Object> parameters) {
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)22);
        String banner = ParameterMap.getKeyedString(parameters, (String)"banner", null);
        String match = ParameterMap.getKeyedString(parameters, (String)"match", null);
        String clientBanner = ParameterMap.getKeyedString(parameters, (String)"client-banner", (String)"SSH-1.99-OpenNMS_1.5");
        PollStatus ps = PollStatus.unavailable();
        Ssh ssh = new Ssh(address, port, tracker.getConnectionTimeout());
        ssh.setClientBanner(clientBanner);
        Pattern regex = null;
        try {
            if (match == null && (banner == null || banner.equals("*"))) {
                regex = null;
            } else if (match != null) {
                regex = Pattern.compile(match);
                LOG.debug("match: /{}/", (Object)match);
            } else if (banner != null) {
                regex = Pattern.compile(banner);
                LOG.debug("banner: /{}/", (Object)banner);
            }
        }
        catch (PatternSyntaxException e) {
            String matchString = match == null ? banner : match;
            LOG.info("Invalid regular expression for SSH banner match /{}/: {}", (Object)matchString, (Object)e.getMessage());
            return ps;
        }
        tracker.reset();
        while (tracker.shouldRetry() && !ps.isAvailable()) {
            try {
                ps = ssh.poll(tracker);
            }
            catch (InsufficientParametersException e) {
                LOG.error("An error occurred polling host '{}'", (Object)address, (Object)e);
                break;
            }
            if (ps.isAvailable()) {
                if (regex == null) {
                    return ps;
                }
                String response = ssh.getServerBanner();
                if (response == null) {
                    return PollStatus.unavailable((String)"server closed connection before banner was received.");
                }
                if (regex.matcher(response).find()) {
                    LOG.debug("isServer: matching response={}", (Object)response);
                    return ps;
                }
                LOG.debug("isServer: NON-matching response={}", (Object)response);
                return PollStatus.unavailable((String)("server responded, but banner did not match '" + banner + "'"));
            }
            tracker.nextAttempt();
        }
        return ps;
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        return this.poll(svc.getAddress(), parameters);
    }
}

