/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.codahale.metrics.Meter;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public class ResourceMetadata
implements Serializable {
    private static final long serialVersionUID = 2103401685689076369L;
    private final Set<String> m_metrics = Sets.newConcurrentHashSet();
    private final Map<String, String> m_attributes = Maps.newConcurrentMap();
    private final transient Meter m_metricReqs;
    private final transient Meter m_attributeReqs;
    private final transient Meter m_metricMisses;
    private final transient Meter m_attributeMisses;
    private Long m_expires = null;

    public ResourceMetadata(Meter metricReqs, Meter attributeReqs, Meter metricMisses, Meter attributeMisses) {
        this.m_metricReqs = metricReqs;
        this.m_attributeReqs = attributeReqs;
        this.m_metricMisses = metricMisses;
        this.m_attributeMisses = attributeMisses;
    }

    public ResourceMetadata() {
        this.m_metricReqs = null;
        this.m_attributeReqs = null;
        this.m_metricMisses = null;
        this.m_attributeMisses = null;
    }

    public boolean containsMetric(String metric) {
        boolean contains;
        if (this.m_metricReqs != null) {
            this.m_metricReqs.mark();
        }
        if (!(contains = this.m_metrics.contains(metric)) && this.m_metricMisses != null) {
            this.m_metricMisses.mark();
        }
        return contains;
    }

    public ResourceMetadata putMetric(String metric) {
        this.m_metrics.add(metric);
        return this;
    }

    public boolean containsAttribute(String key, String value) {
        boolean contains;
        if (this.m_attributeReqs != null) {
            this.m_attributeReqs.mark();
        }
        boolean bl = contains = this.m_attributes.containsKey(key) && this.m_attributes.get(key).equals(value);
        if (!contains && this.m_attributeMisses != null) {
            this.m_attributeMisses.mark();
        }
        return contains;
    }

    public ResourceMetadata putAttribute(String key, String value) {
        this.m_attributes.put(key, value);
        return this;
    }

    public long getExpires() {
        return this.m_expires;
    }

    public ResourceMetadata setExpires(Long expires) {
        this.m_expires = expires;
        return this;
    }

    public boolean expired(long currentTimeMillis) {
        return this.m_expires == null || this.m_expires <= currentTimeMillis;
    }

    public boolean merge(ResourceMetadata other) {
        boolean modified = this.m_metrics.addAll(other.m_metrics);
        if (!modified) {
            modified = !this.m_attributes.equals(other.m_attributes);
        }
        this.m_attributes.putAll(other.m_attributes);
        this.m_expires = (Long)Ordering.natural().nullsLast().min((Object)this.m_expires, (Object)other.m_expires);
        return modified;
    }

    public String toString() {
        return String.format("%s[metric=%s, attributes=%s]", this.getClass().getSimpleName(), this.m_metrics, this.m_attributes);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_attributes == null ? 0 : this.m_attributes.hashCode());
        result = 31 * result + (this.m_metrics == null ? 0 : this.m_metrics.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceMetadata other = (ResourceMetadata)obj;
        if (this.m_attributes == null ? other.m_attributes != null : !this.m_attributes.equals(other.m_attributes)) {
            return false;
        }
        return !(this.m_metrics == null ? other.m_metrics != null : !this.m_metrics.equals(other.m_metrics));
    }
}

