/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import javax.inject.Inject;
import javax.inject.Named;

public class CassandraIndexingOptions {
    private final boolean m_enableHierarchicalIndexing;
    private final boolean m_indexUsingDefaultTerm;
    private final boolean m_indexResourceTerms;
    private final int m_maxBatchSize;

    public CassandraIndexingOptions(Builder builder) {
        this.m_maxBatchSize = builder.maxBatchSize;
        this.m_enableHierarchicalIndexing = builder.enableHierarchicalIndexing;
        this.m_indexUsingDefaultTerm = builder.indexUsingDefaultTerm;
        this.m_indexResourceTerms = builder.indexResourceTerms;
    }

    @Inject
    public CassandraIndexingOptions(@Named(value="search.hierarical-indexing") boolean enableHierarchicalIndexing) {
        this(new Builder().withHierarchicalIndexing(enableHierarchicalIndexing));
    }

    public boolean isHierarchicalIndexingEnabled() {
        return this.m_enableHierarchicalIndexing;
    }

    public boolean shouldIndexUsingDefaultTerm() {
        return this.m_indexUsingDefaultTerm;
    }

    public boolean shouldIndexResourceTerms() {
        return this.m_indexResourceTerms;
    }

    public int getMaxBatchSize() {
        return this.m_maxBatchSize;
    }

    public static class Builder {
        private int maxBatchSize = 16;
        private boolean enableHierarchicalIndexing = true;
        private boolean indexUsingDefaultTerm = true;
        private boolean indexResourceTerms = true;

        public Builder withHierarchicalIndexing(boolean enableHierarchicalIndexing) {
            this.enableHierarchicalIndexing = enableHierarchicalIndexing;
            return this;
        }

        public Builder withIndexUsingDefaultTerm(boolean indexUsingDefaultTerm) {
            this.indexUsingDefaultTerm = indexUsingDefaultTerm;
            return this;
        }

        public Builder withIndexResourceTerms(boolean indexResourceTerms) {
            this.indexResourceTerms = indexResourceTerms;
            return this;
        }

        public Builder withMaxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public CassandraIndexingOptions build() {
            return new CassandraIndexingOptions(this);
        }
    }
}

