/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.opennms.core.spring.FileReloadCallback;
import org.opennms.core.spring.FileReloadContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWatcher<T>
implements Runnable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryWatcher.class);
    private Path m_path;
    private Thread m_thread;
    private File m_directory;
    private FileReloadCallback<T> m_loader;
    private ConcurrentHashMap<String, FileReloadContainer<T>> m_contents = new ConcurrentHashMap();
    private volatile boolean m_stopped = true;

    public DirectoryWatcher(File directory, FileReloadCallback<T> loader) throws InterruptedException {
        this.m_directory = directory;
        if (!this.m_directory.exists() && !this.m_directory.mkdirs()) {
            LOG.warn("Could not make directory: {}", (Object)this.m_directory.getPath());
        }
        this.m_loader = loader;
        if (this.m_directory != null) {
            this.m_path = Paths.get(this.m_directory.getAbsolutePath(), new String[0]);
            this.start();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.stop();
        }
        catch (InterruptedException e) {
            LOG.warn("request to stop failed, guess its time to stop being polite!");
        }
    }

    public void join() throws InterruptedException {
        this.m_thread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info("starting run loop");
        try (WatchService watcher = this.m_path.getFileSystem().newWatchService();){
            LOG.debug("registering create watcher on {}", (Object)this.m_path.toAbsolutePath().toString());
            this.m_path.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            LOG.debug("watcher registration complete for {}", (Object)this.m_path.toAbsolutePath().toString());
            DirectoryWatcher directoryWatcher = this;
            synchronized (directoryWatcher) {
                this.notifyAll();
            }
            block12: while (!this.m_stopped) {
                WatchKey key;
                if (this.m_thread.isInterrupted()) {
                    break;
                }
                try {
                    LOG.trace("waiting for create event");
                    key = watcher.poll(1L, TimeUnit.SECONDS);
                    if (key == null) continue;
                    LOG.trace("got an event, process it");
                }
                catch (InterruptedException ie) {
                    LOG.info("interrupted, must be time to shut down...");
                    break;
                }
                for (WatchEvent<?> watchEvent : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    Path pathChanged = (Path)watchEvent.context();
                    String fileName = pathChanged.toString();
                    File file = new File(this.m_directory, fileName);
                    if (file.isDirectory()) {
                        LOG.debug("{} is a directory, ignoring.", (Object)file);
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        LOG.debug("overflow receiving, ignoring changes.");
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        LOG.info("file '{}' created. Ignoring...", (Object)fileName);
                    } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        LOG.info("file '{}' modified. Removing entry from cache.", (Object)fileName);
                        this.m_contents.remove(fileName);
                    } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        LOG.info("file '{}' deleted. Removing entry from cache.", (Object)fileName);
                        this.m_contents.remove(fileName);
                    }
                    if (key.reset()) continue;
                    continue block12;
                }
            }
        }
        catch (IOException ioe) {
            LOG.error(ioe.getMessage(), (Throwable)ioe);
        }
        LOG.info("existing run loop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws InterruptedException {
        if (this.m_thread != null) {
            this.stop();
        }
        LOG.trace("starting monitor");
        this.m_thread = new Thread((Runnable)this, "DirectoryWatcher-" + this.m_directory.getParentFile().getName() + "-" + this.m_directory.getName());
        this.m_stopped = false;
        this.m_thread.start();
        DirectoryWatcher directoryWatcher = this;
        synchronized (directoryWatcher) {
            this.wait();
        }
        LOG.trace("monitor started");
    }

    public synchronized void stop() throws InterruptedException {
        LOG.trace("stopping monitor");
        this.m_stopped = true;
        this.m_thread.interrupt();
        this.m_thread.join();
        this.m_thread = null;
        LOG.trace("monitor stopped");
    }

    public Set<String> getFileNames() {
        String[] list = this.m_directory.list();
        return new LinkedHashSet<String>(Arrays.asList(list));
    }

    public Set<String> getBaseNamesWithExtension(String extension) {
        Set<String> fileNames = this.getFileNames();
        LinkedHashSet<String> basenames = new LinkedHashSet<String>();
        for (String fileName : fileNames) {
            if (!fileName.endsWith(extension)) continue;
            String basename = fileName.substring(0, fileName.length() - extension.length());
            basenames.add(basename);
        }
        return basenames;
    }

    public T getContents(String fileName) throws FileNotFoundException {
        File file = new File(this.m_directory, fileName);
        if (file.exists() && !file.isDirectory()) {
            FileReloadContainer newContainer = new FileReloadContainer(file, this.m_loader);
            newContainer.setReloadCheckInterval(0L);
            FileReloadContainer container = this.m_contents.putIfAbsent(fileName, newContainer);
            if (container == null) {
                LOG.debug("getting content of {}", (Object)file);
                container = newContainer;
            }
            return (T)container.getObject();
        }
        this.m_contents.remove(fileName);
        throw new FileNotFoundException("there is no file called '" + fileName + "' in directory " + String.valueOf(this.m_directory));
    }
}

