/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc.datablock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.rtc.datablock.RTCNode;

public class RTCCategory
extends Category {
    private static final long serialVersionUID = -3599148594628072528L;
    private final String m_effectiveRule;
    private final List<Integer> m_nodes = Collections.synchronizedList(new ArrayList());

    public RTCCategory(Category cat, String commonRule) {
        this.setLabel(cat.getLabel());
        this.setComment(cat.getComment().orElse(null));
        this.setRule(cat.getRule());
        this.setNormalThreshold(cat.getNormalThreshold());
        this.setWarningThreshold(cat.getWarningThreshold());
        this.setServices(cat.getServices());
        this.m_effectiveRule = "(" + commonRule + ") & (" + cat.getRule() + ")";
    }

    public void addNode(RTCNode node) {
        Integer longnodeid = node.getNodeID();
        if (!this.m_nodes.contains(longnodeid)) {
            this.m_nodes.add(longnodeid);
        }
    }

    public void addNode(int nodeid) {
        if (!this.m_nodes.contains(nodeid)) {
            this.m_nodes.add(nodeid);
        }
    }

    public void deleteNode(int nodeid) {
        this.m_nodes.remove((Object)nodeid);
    }

    public void clearNodes() {
        this.m_nodes.clear();
    }

    public void addAllNodes(Collection<Integer> nodes) {
        this.m_nodes.addAll(nodes);
    }

    public boolean containsService(String svcname) {
        List services = this.getServices();
        if (services.size() == 0) {
            return true;
        }
        return services.contains(svcname);
    }

    public String getEffectiveRule() {
        return this.m_effectiveRule;
    }

    public List<Integer> getNodes() {
        return this.m_nodes;
    }
}

