/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OmsaStorageMonitor
extends SnmpMonitorStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(OmsaStorageMonitor.class);
    private static final String virtualDiskRollUpStatus = ".1.3.6.1.4.1.674.10893.1.20.140.1.1.19";
    private static final String arrayDiskLogicalConnectionVirtualDiskNumber = ".1.3.6.1.4.1.674.10893.1.20.140.3.1.5";
    private static final String arrayDiskNexusID = ".1.3.6.1.4.1.674.10893.1.20.130.4.1.26";
    private static final String arrayDiskLogicalConnectionArrayDiskNumber = ".1.3.6.1.4.1.674.10893.1.20.140.3.1.3";
    private static final String arrayDiskState = ".1.3.6.1.4.1.674.10893.1.20.130.4.1.4";

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        PollStatus status = PollStatus.available();
        InetAddress ipaddr = svc.getAddress();
        StringBuilder returnValue = new StringBuilder();
        SnmpAgentConfig agentConfig = this.configureAgent(svc, parameters);
        Integer virtualDiskNumber = ParameterMap.getKeyedInteger(parameters, (String)"virtualDiskNumber", (int)1);
        LOG.debug("poll: service= SNMP address= {}", (Object)agentConfig);
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        try {
            LOG.debug("OMSAStorageMonitor.poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            SnmpObjId virtualDiskRollUpStatusSnmpObject = SnmpObjId.get((String)(".1.3.6.1.4.1.674.10893.1.20.140.1.1.19." + virtualDiskNumber));
            SnmpValue virtualDiskRollUpStatus = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)virtualDiskRollUpStatusSnmpObject);
            if (virtualDiskRollUpStatus == null || virtualDiskRollUpStatus.isNull()) {
                LOG.debug("SNMP poll failed: no results, addr={} oid={}", (Object)hostAddress, (Object)virtualDiskRollUpStatusSnmpObject);
                return PollStatus.unavailable();
            }
            if (virtualDiskRollUpStatus.toInt() != 3) {
                returnValue.append("log vol(").append(virtualDiskNumber).append(") degraded");
                SnmpObjId arrayDiskLogicalConnectionVirtualDiskNumberSnmpObject = SnmpObjId.get((String)arrayDiskLogicalConnectionVirtualDiskNumber);
                Map arrayDisks = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"OMSAStorageMonitor", (SnmpObjId)arrayDiskLogicalConnectionVirtualDiskNumberSnmpObject);
                SnmpObjId arrayDiskLogicalConnectionArrayDiskNumberSnmpObject = SnmpObjId.get((String)arrayDiskLogicalConnectionArrayDiskNumber);
                Map arrayDiskConnectionNumber = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"OMSAStorageMonitor", (SnmpObjId)arrayDiskLogicalConnectionArrayDiskNumberSnmpObject);
                for (Map.Entry disk : arrayDisks.entrySet()) {
                    LOG.debug("OMSAStorageMonitor :: arrayDiskNembers=", disk.getValue());
                    if (((SnmpValue)disk.getValue()).toInt() != virtualDiskNumber.intValue()) continue;
                    LOG.debug("OMSAStorageMonitor :: Disk Found! ");
                    LOG.debug("OMSAStorageMonitor :: Found This Array Disk Value {}", disk.getKey());
                    SnmpObjId arrayDiskStateSnmpObject = SnmpObjId.get((String)(".1.3.6.1.4.1.674.10893.1.20.130.4.1.4." + String.valueOf(arrayDiskConnectionNumber.get(disk.getKey()))));
                    SnmpValue diskValue = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)arrayDiskStateSnmpObject);
                    LOG.debug("OmsaStorageMonitor :: Disk State=", (Object)diskValue);
                    if (diskValue.toInt() == 3) continue;
                    String arrayDiskState = this.getArrayDiskStatus(diskValue);
                    SnmpObjId arrayDiskNexusIDSnmpObject = SnmpObjId.get((String)(".1.3.6.1.4.1.674.10893.1.20.130.4.1.26." + ((SnmpInstId)disk.getKey()).toString()));
                    SnmpValue nexusValue = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)arrayDiskNexusIDSnmpObject);
                    returnValue.append(" phy drv(").append(nexusValue).append(") ").append(arrayDiskState);
                }
                return PollStatus.unavailable(returnValue.toString());
            }
        }
        catch (NumberFormatException e) {
            String reason = "Number operator used on a non-number " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable(reason);
        }
        catch (IllegalArgumentException e) {
            String reason = "Invalid SNMP Criteria: " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable(reason);
        }
        catch (Throwable t) {
            String reason = "Unexpected exception during SNMP poll of interface " + hostAddress;
            LOG.debug(reason, t);
            status = PollStatus.unavailable(reason);
        }
        return status;
    }

    private SnmpAgentConfig configureAgent(MonitoredService svc, Map<String, Object> parameters) {
        SnmpAgentConfig agentConfig = this.getAgentConfig(svc, parameters);
        LOG.debug("poll: setting SNMP peer attribute for interface {}", (Object)InetAddressUtils.str((InetAddress)svc.getAddress()));
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        return agentConfig;
    }

    private String getArrayDiskStatus(SnmpValue diskValue) {
        switch (diskValue.toInt()) {
            case 1: {
                return "Ready";
            }
            case 2: {
                return "Failed";
            }
            case 3: {
                return "Online";
            }
            case 4: {
                return "Offline";
            }
            case 6: {
                return "Degraded";
            }
            case 7: {
                return "Recovering";
            }
            case 11: {
                return "Removed";
            }
            case 15: {
                return "Resynching";
            }
            case 24: {
                return "Rebuilding";
            }
            case 25: {
                return "noMedia";
            }
            case 26: {
                return "Formating";
            }
            case 28: {
                return "Running Diagnostics";
            }
            case 35: {
                return "Initializing";
            }
        }
        return null;
    }
}

