/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetScalerGroupHealthMonitor
extends SnmpMonitorStrategy {
    private static final String SVC_GRP_MEMBER_STATE = ".1.3.6.1.4.1.5951.4.1.2.7.1.6";
    private static final Logger LOG = LoggerFactory.getLogger(NetScalerGroupHealthMonitor.class);

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        InetAddress ipaddr = svc.getAddress();
        SnmpAgentConfig agentConfig = this.getAgentConfig(svc, parameters);
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        PollStatus status = PollStatus.unavailable("NetScalerGroupHealthMonitor: cannot determinate group health, addr=" + hostAddress);
        int groupHealth = ParameterMap.getKeyedInteger(parameters, (String)"group-health", (int)60);
        String groupName = ParameterMap.getKeyedString(parameters, (String)"group-name", null);
        if (groupName == null) {
            status.setReason("NetScalerGroupHealthMonitor no group-name defined, addr=" + hostAddress);
            LOG.warn("NetScalerGroupHealthMonitor.poll: No Service Name Defined!");
            return status;
        }
        int snLength = groupName.length();
        StringBuilder serviceOidBuf = new StringBuilder(SVC_GRP_MEMBER_STATE);
        serviceOidBuf.append(".").append(Integer.toString(snLength));
        for (byte thisByte : groupName.getBytes()) {
            serviceOidBuf.append(".").append(Byte.toString(thisByte));
        }
        LOG.debug("For group name '{}', OID to check is {}", (Object)groupName, (Object)serviceOidBuf.toString());
        try {
            final SnmpObjId groupStateOid = SnmpObjId.get((String)serviceOidBuf.toString());
            final HashMap hostResults = new HashMap();
            RowCallback callback = new RowCallback(){

                public void rowCompleted(SnmpRowResult result) {
                    hostResults.put(result.getInstance(), result.getValue(groupStateOid));
                }
            };
            TableTracker tracker = new TableTracker(callback, new SnmpObjId[]{groupStateOid});
            try (SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"NetScalerGroupHealthMonitor", (CollectionTracker)tracker);){
                walker.start();
                walker.waitFor();
            }
            int totalServers = hostResults.size();
            if (totalServers == 0) {
                status = PollStatus.unavailable("NetScalerGroupHealthMonitor poll failed: there are 0 servers on group " + groupName + " for " + hostAddress);
                LOG.debug(status.getReason());
            }
            int activeServers = 0;
            for (SnmpValue v : hostResults.values()) {
                if (v.toInt() != 7) continue;
                ++activeServers;
            }
            double health = new Double(activeServers) / new Double(totalServers) * 100.0;
            LOG.debug("There are {} of {} active servers ({}%) on group {} for NetScaler {}", new Object[]{activeServers, totalServers, health, groupName, hostAddress});
            if (health >= (double)groupHealth) {
                status = PollStatus.available();
            } else {
                status = PollStatus.unavailable("NetScalerGroupHealthMonitor poll failed: there are " + activeServers + " of " + totalServers + " servers active (" + health + "%) on group " + groupName + ", which is less than " + groupHealth + "% for " + hostAddress);
                LOG.debug(status.getReason());
            }
        }
        catch (Throwable t) {
            status = PollStatus.unavailable("Unexpected exception during SNMP poll of interface " + hostAddress);
            LOG.warn(status.getReason(), t);
        }
        return status;
    }
}

