/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;

public class SnmpInterfaceBuilder {
    private final OnmsSnmpInterface m_snmpIf;

    public SnmpInterfaceBuilder(OnmsSnmpInterface snmpIf) {
        this.m_snmpIf = snmpIf;
    }

    public SnmpInterfaceBuilder setIfSpeed(long ifSpeed) {
        this.m_snmpIf.setIfSpeed(new Long(ifSpeed));
        return this;
    }

    public SnmpInterfaceBuilder setIfDescr(String ifDescr) {
        this.m_snmpIf.setIfDescr(ifDescr);
        return this;
    }

    public SnmpInterfaceBuilder setIfAlias(String ifAlias) {
        this.m_snmpIf.setIfAlias(ifAlias);
        return this;
    }

    public SnmpInterfaceBuilder setIfName(String ifName) {
        this.m_snmpIf.setIfName(ifName);
        return this;
    }

    public SnmpInterfaceBuilder setIfType(Integer ifType) {
        this.m_snmpIf.setIfType(ifType);
        return this;
    }

    public OnmsSnmpInterface getSnmpInterface() {
        return this.m_snmpIf;
    }

    public SnmpInterfaceBuilder setIfOperStatus(Integer ifOperStatus) {
        this.m_snmpIf.setIfOperStatus(ifOperStatus);
        return this;
    }

    public SnmpInterfaceBuilder setCollectionEnabled(boolean collect) {
        this.m_snmpIf.setCollectionEnabled(collect);
        return this;
    }

    public SnmpInterfaceBuilder setPhysAddr(String physAddr) {
        this.m_snmpIf.setPhysAddr(physAddr);
        return this;
    }

    public NetworkBuilder.InterfaceBuilder addIpInterface(String ipAddress) {
        return this.addIpInterface(InetAddressUtils.addr((String)ipAddress));
    }

    public NetworkBuilder.InterfaceBuilder addIpInterface(InetAddress ipAddress) {
        OnmsIpInterface iface = new OnmsIpInterface(ipAddress, this.m_snmpIf.getNode());
        this.m_snmpIf.addIpInterface(iface);
        return new NetworkBuilder.InterfaceBuilder(iface);
    }
}

