/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd.jmx;

import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapdInstrumentation {
    private static final Logger LOG = LoggerFactory.getLogger(TrapdInstrumentation.class);
    private final AtomicLong trapsReceived = new AtomicLong();
    private final AtomicLong v1TrapsReceived = new AtomicLong();
    private final AtomicLong v2cTrapsReceived = new AtomicLong();
    private final AtomicLong v3TrapsReceived = new AtomicLong();
    private final AtomicLong vUnknownTrapsReceived = new AtomicLong();
    private final AtomicLong trapsDiscarded = new AtomicLong();
    private final AtomicLong trapsErrored = new AtomicLong();

    public void incTrapsReceivedCount(String version) {
        this.trapsReceived.incrementAndGet();
        if ("v1".equals(version)) {
            this.v1TrapsReceived.incrementAndGet();
        } else if ("v2c".equals(version) || "v2".equals(version)) {
            this.v2cTrapsReceived.incrementAndGet();
        } else if ("v3".equals(version)) {
            this.v3TrapsReceived.incrementAndGet();
        } else {
            this.vUnknownTrapsReceived.incrementAndGet();
            LOG.warn("Received a trap with an unknown SNMP protocol version '{}'.", (Object)version);
        }
    }

    public void incDiscardCount() {
        this.trapsDiscarded.incrementAndGet();
    }

    public void incErrorCount() {
        this.trapsErrored.incrementAndGet();
    }

    public long getV1TrapsReceived() {
        return this.v1TrapsReceived.get();
    }

    public long getV2cTrapsReceived() {
        return this.v2cTrapsReceived.get();
    }

    public long getV3TrapsReceived() {
        return this.v3TrapsReceived.get();
    }

    public long getVUnknownTrapsReceived() {
        return this.vUnknownTrapsReceived.get();
    }

    public long getTrapsDiscarded() {
        return this.trapsDiscarded.get();
    }

    public long getTrapsErrored() {
        return this.trapsErrored.get();
    }

    public long getTrapsReceived() {
        return this.trapsReceived.get();
    }
}

