/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.function.Function;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.Packet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerAccessor;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.InitiationPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.PeerDownPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.PeerUpPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.RouteMirroringPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.RouteMonitoringPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.StatisticsReportPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.TerminationPacket;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.UnknownPacket;

public class Header {
    public static final int SIZE = 6;
    public static final int VERSION = 3;
    public final int version;
    public final int length;
    public final Type type;

    public Header(ByteBuf buffer) throws InvalidPacketException {
        this.version = BufferUtils.uint8((ByteBuf)buffer);
        if (this.version != 3) {
            throw new InvalidPacketException(buffer, "Invalid version number: 0x%04X", this.version);
        }
        this.length = (int)BufferUtils.uint32((ByteBuf)buffer);
        if (this.length == 0) {
            throw new InvalidPacketException(buffer, "Zero length record", new Object[0]);
        }
        this.type = Type.from(buffer);
    }

    public int payloadLength() {
        return this.length - 6;
    }

    public Packet parsePayload(ByteBuf buffer, PeerAccessor peerAccessor) throws InvalidPacketException {
        return this.type.parse(this, buffer, peerAccessor);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.version).add("length", this.length).add("type", (Object)this.type).toString();
    }

    public static enum Type {
        ROUTE_MONITORING(RouteMonitoringPacket::new),
        STATISTICS_REPORT(StatisticsReportPacket::new),
        PEER_DOWN_NOTIFICATION(PeerDownPacket::new),
        PEER_UP_NOTIFICATION(PeerUpPacket::new),
        INITIATION_MESSAGE(InitiationPacket::new),
        TERMINATION_MESSAGE(TerminationPacket::new),
        ROUTE_MIRRORING_MESSAGE(RouteMirroringPacket::new),
        UNKNOWN(UnknownPacket::new);

        private final Packet.Parser parser;

        private Type(Packet.Parser parser) {
            this.parser = Objects.requireNonNull(parser);
        }

        private Packet parse(Header header, ByteBuf buffer, PeerAccessor peerAccessor) throws InvalidPacketException {
            return this.parser.parse(header, buffer, peerAccessor);
        }

        private static Type from(ByteBuf buffer) throws InvalidPacketException {
            int type = BufferUtils.uint8((ByteBuf)buffer);
            switch (type) {
                case 0: {
                    return ROUTE_MONITORING;
                }
                case 1: {
                    return STATISTICS_REPORT;
                }
                case 2: {
                    return PEER_DOWN_NOTIFICATION;
                }
                case 3: {
                    return PEER_UP_NOTIFICATION;
                }
                case 4: {
                    return INITIATION_MESSAGE;
                }
                case 5: {
                    return TERMINATION_MESSAGE;
                }
                case 6: {
                    return ROUTE_MIRRORING_MESSAGE;
                }
            }
            BmpParser.RATE_LIMITED_LOG.debug("Unknown BMP Packet Type: {}", (Object)type);
            return UNKNOWN;
        }

        public <R> R map(Function<Type, R> mapper) {
            return mapper.apply(this);
        }
    }
}

