/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.processor;

import java.util.List;
import org.opensaml.common.binding.security.SAMLProtocolMessageXMLSignatureSecurityPolicyRule;
import org.opensaml.saml2.binding.decoding.HTTPRedirectDeflateDecoder;
import org.opensaml.saml2.binding.encoding.HTTPRedirectDeflateEncoder;
import org.opensaml.saml2.binding.security.SAML2HTTPRedirectDeflateSignatureRule;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransport;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.processor.SAMLBindingImpl;

public class HTTPRedirectDeflateBinding
extends SAMLBindingImpl {
    public HTTPRedirectDeflateBinding(ParserPool parserPool) {
        this((MessageDecoder)new HTTPRedirectDeflateDecoder(parserPool), (MessageEncoder)new HTTPRedirectDeflateEncoder());
    }

    public HTTPRedirectDeflateBinding(MessageDecoder decoder, MessageEncoder encoder) {
        super(decoder, encoder);
    }

    @Override
    public boolean supports(InTransport transport) {
        if (transport instanceof HTTPInTransport) {
            HTTPTransport t = (HTTPTransport)transport;
            return "GET".equalsIgnoreCase(t.getHTTPMethod()) && (t.getParameterValue("SAMLRequest") != null || t.getParameterValue("SAMLResponse") != null);
        }
        return false;
    }

    @Override
    public boolean supports(OutTransport transport) {
        return transport instanceof HTTPOutTransport;
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    }

    @Override
    public void getSecurityPolicy(List<SecurityPolicyRule> securityPolicy, SAMLMessageContext samlContext) {
        SignatureTrustEngine engine = samlContext.getLocalTrustEngine();
        securityPolicy.add((SecurityPolicyRule)new SAML2HTTPRedirectDeflateSignatureRule(engine));
        securityPolicy.add((SecurityPolicyRule)new SAMLProtocolMessageXMLSignatureSecurityPolicyRule((TrustEngine)engine));
    }
}

