/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.osgi.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.opennms.osgi.EventRegistry;
import org.opennms.osgi.OnmsServiceManager;
import org.opennms.osgi.internal.OnmsServiceManagerImpl;
import org.opennms.vaadin.extender.SessionListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private final Logger Log = LoggerFactory.getLogger(this.getClass());

    public void start(BundleContext context) throws Exception {
        context.addBundleListener((BundleListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        if (event == null) {
            return;
        }
        if (128 == event.getType() && this.shouldAutoExportOnmsServices(event.getBundle())) {
            this.autoExportDefaultServices(event.getBundle().getBundleContext());
        } else if (4 == event.getType()) {
            // empty if block
        }
    }

    private void autoExportDefaultServices(BundleContext bundleContext) {
        long bundleId = bundleContext.getBundle().getBundleId();
        this.Log.info("Auto export of default Services for bundle (id: {}) enabled", (Object)bundleId);
        OnmsServiceManagerImpl serviceManager = new OnmsServiceManagerImpl(bundleContext);
        Hashtable<String, Long> props = new Hashtable<String, Long>();
        ((Dictionary)props).put("bundleId", bundleContext.getBundle().getBundleId());
        this.Log.info("Registering OnmsServiceManager and SessionListener for bundle (id: {})", (Object)bundleId);
        bundleContext.registerService(new String[]{OnmsServiceManager.class.getName(), SessionListener.class.getName()}, (Object)serviceManager, props);
        this.Log.info("Registering EventRegistry for bundle (id: {})", (Object)bundleId);
        bundleContext.registerService(EventRegistry.class.getName(), (Object)new EventRegistry(bundleContext), props);
    }

    private boolean shouldAutoExportOnmsServices(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        String headerValue = (String)bundle.getHeaders().get("OnmsAutoExportServices");
        if (headerValue == null) {
            return false;
        }
        return Boolean.valueOf(headerValue);
    }
}

