/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.Aggregation;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.Bucket;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class ProportionalSumAggregation
extends Aggregation {
    public static final String TYPE = "partial_sum";
    private List<DateHistogram> dateHistograms = new LinkedList<DateHistogram>();

    public ProportionalSumAggregation(String name, JsonObject PartialSumAggregation) {
        super(name, PartialSumAggregation);
        if (PartialSumAggregation.has(String.valueOf(AggregationField.BUCKETS)) && PartialSumAggregation.get(String.valueOf(AggregationField.BUCKETS)).isJsonArray()) {
            this.parseBuckets(PartialSumAggregation.get(String.valueOf(AggregationField.BUCKETS)).getAsJsonArray());
        }
    }

    private void parseBuckets(JsonArray bucketsSource) {
        for (JsonElement bucket : bucketsSource) {
            JsonObject bucketObj = bucket.getAsJsonObject();
            JsonElement keyElement = bucketObj.get(String.valueOf(AggregationField.KEY));
            Long time = keyElement != null ? Long.valueOf(keyElement.getAsLong()) : null;
            if (time == null) continue;
            JsonElement keyAsStringElement = bucketObj.get(String.valueOf(AggregationField.KEY_AS_STRING));
            String timeAsString = keyAsStringElement != null ? keyAsStringElement.getAsString() : String.valueOf(time);
            JsonElement docCountElement = bucketObj.get(String.valueOf(AggregationField.DOC_COUNT));
            Long count = docCountElement != null ? docCountElement.getAsLong() : 0L;
            JsonElement valueElement = bucketObj.get(String.valueOf(AggregationField.VALUE));
            Double value = valueElement != null ? valueElement.getAsDouble() : 0.0;
            this.dateHistograms.add(new DateHistogram(bucketObj, time, timeAsString, value, count));
        }
    }

    public List<DateHistogram> getBuckets() {
        return this.dateHistograms;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ProportionalSumAggregation rhs = (ProportionalSumAggregation)((Object)obj);
        return super.equals(obj) && Objects.equals(this.dateHistograms, rhs.dateHistograms);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dateHistograms);
    }

    public class DateHistogram
    extends Histogram {
        private String timeAsString;
        private Double value;

        DateHistogram(JsonObject bucket, Long time, String timeAsString, Double value, Long count) {
            super(bucket, time, count);
            this.timeAsString = timeAsString;
            this.value = value;
        }

        public Long getTime() {
            return this.getKey();
        }

        public String getTimeAsString() {
            return this.timeAsString;
        }

        public Double getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            DateHistogram rhs = (DateHistogram)((Object)obj);
            return super.equals(obj) && Objects.equals(this.timeAsString, rhs.timeAsString) && Objects.equals(this.value, rhs.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.timeAsString);
        }

        public String toString() {
            return "DateHistogram{timeAsString='" + this.timeAsString + "', value=" + this.value + ", count=" + this.count + "}";
        }
    }

    public static class Histogram
    extends Bucket {
        private Long key;

        Histogram(JsonObject bucket, Long key, Long count) {
            super(bucket, count);
            this.key = key;
        }

        public Long getKey() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Histogram rhs = (Histogram)((Object)obj);
            return super.equals(obj) && Objects.equals(this.key, rhs.key);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.key);
        }
    }
}

