/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.features.elastic.client.ElasticRestClient;
import org.opennms.features.jest.client.ConnectionPoolShutdownException;
import org.opennms.features.jest.client.template.CachingTemplateLoader;
import org.opennms.features.jest.client.template.IndexSettings;
import org.opennms.features.jest.client.template.MergingTemplateLoader;
import org.opennms.features.jest.client.template.OsgiTemplateLoader;
import org.opennms.features.jest.client.template.TemplateInitializer;
import org.opennms.features.jest.client.template.TemplateLoader;
import org.opennms.features.jest.client.template.Version;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticRestTemplateInitializer
implements TemplateInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticRestTemplateInitializer.class);
    private static final long[] COOL_DOWN_TIMES_IN_MS = new long[]{250L, 500L, 1000L, 5000L, 10000L, 60000L};
    private final AtomicInteger retryCount = new AtomicInteger(0);
    private final ElasticRestClient client;
    private final TemplateLoader templateLoader;
    private final String templateLocation;
    private final String templateName;
    private final IndexSettings indexSettings;
    private boolean initialized;

    public ElasticRestTemplateInitializer(BundleContext bundleContext, ElasticRestClient client, String templateLocation, String templateName) {
        this(client, templateLocation, templateName, (TemplateLoader)new CachingTemplateLoader((TemplateLoader)new OsgiTemplateLoader(bundleContext)), new IndexSettings());
    }

    public ElasticRestTemplateInitializer(BundleContext bundleContext, ElasticRestClient client, String templateLocation, String templateName, IndexSettings indexSettings) {
        this(client, templateLocation, templateName, (TemplateLoader)new CachingTemplateLoader((TemplateLoader)new MergingTemplateLoader((TemplateLoader)new OsgiTemplateLoader(bundleContext), indexSettings)), indexSettings);
    }

    protected ElasticRestTemplateInitializer(ElasticRestClient client, String templateLocation, String templateName, TemplateLoader templateLoader, IndexSettings indexSettings) {
        this.client = Objects.requireNonNull(client);
        this.templateLocation = templateLocation;
        this.templateName = Objects.requireNonNull(templateName);
        this.templateLoader = Objects.requireNonNull(templateLoader);
        this.indexSettings = Objects.requireNonNull(indexSettings);
    }

    public synchronized void initialize() {
        while (!this.initialized && !Thread.interrupted()) {
            try {
                LOG.debug("Template {} is not initialized. Initializing...", (Object)this.templateName);
                this.doInitialize();
                this.initialized = true;
            }
            catch (ConnectionPoolShutdownException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOG.error("An error occurred while initializing template {}: {}.", new Object[]{this.templateName, ex.getMessage(), ex});
                long coolDownTimeInMs = COOL_DOWN_TIMES_IN_MS[this.retryCount.get()];
                LOG.debug("Retrying in {} ms", (Object)coolDownTimeInMs);
                this.waitBeforeRetrying(coolDownTimeInMs);
                if (this.retryCount.get() == COOL_DOWN_TIMES_IN_MS.length - 1) continue;
                this.retryCount.incrementAndGet();
            }
        }
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public boolean isComposableTemplate() {
        return false;
    }

    private void waitBeforeRetrying(long cooldown) {
        try {
            Thread.sleep(cooldown);
        }
        catch (InterruptedException e) {
            LOG.warn("Sleep was interrupted", (Throwable)e);
        }
    }

    private void doInitialize() throws IOException {
        boolean success;
        Version version = this.getServerVersion();
        String template = this.templateLoader.load(version, this.templateLocation);
        Object effectiveTemplateName = this.templateName;
        if (this.indexSettings.getIndexPrefix() != null) {
            effectiveTemplateName = this.indexSettings.getIndexPrefix() + this.templateName;
        }
        if (!(success = this.client.applyLegacyIndexTemplate((String)effectiveTemplateName, template))) {
            throw new IllegalStateException("Template '" + this.templateName + "' could not be persisted.");
        }
    }

    private Version getServerVersion() throws IOException {
        String versionString = this.client.getServerVersion();
        return Version.fromVersionString((String)versionString);
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }
}

