/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.internal.collection.DatacollectionConfigVisitor;

@XmlRootElement(name="include-collection", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="datacollection-config.xsd")
public class IncludeCollection
implements Serializable {
    private static final long serialVersionUID = 1736111882579250557L;
    @XmlAttribute(name="systemDef")
    private String m_systemDef;
    @XmlAttribute(name="dataCollectionGroup")
    private String m_dataCollectionGroup;
    @XmlElement(name="exclude-filter")
    private List<String> m_excludeFilters = new ArrayList<String>();

    public String getSystemDef() {
        return this.m_systemDef;
    }

    public void setSystemDef(String systemDef) {
        this.m_systemDef = systemDef.intern();
    }

    public String getDataCollectionGroup() {
        return this.m_dataCollectionGroup;
    }

    public void setDataCollectionGroup(String dataCollectionGroup) {
        this.m_dataCollectionGroup = dataCollectionGroup.intern();
    }

    public List<String> getExcludeFilters() {
        if (this.m_excludeFilters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_excludeFilters);
    }

    public void setExcludeFilters(List<String> excludeFilters) {
        this.m_excludeFilters = new ArrayList<String>(excludeFilters);
    }

    public void addExcludeFilter(String excludeFilter) throws IndexOutOfBoundsException {
        this.m_excludeFilters.add(excludeFilter);
    }

    public boolean removeExcludeFilter(String excludeFilter) {
        return this.m_excludeFilters.remove(excludeFilter);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_dataCollectionGroup == null ? 0 : this.m_dataCollectionGroup.hashCode());
        result = 31 * result + (this.m_excludeFilters == null ? 0 : this.m_excludeFilters.hashCode());
        result = 31 * result + (this.m_systemDef == null ? 0 : this.m_systemDef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncludeCollection)) {
            return false;
        }
        IncludeCollection other = (IncludeCollection)obj;
        if (this.m_dataCollectionGroup == null ? other.m_dataCollectionGroup != null : !this.m_dataCollectionGroup.equals(other.m_dataCollectionGroup)) {
            return false;
        }
        if (this.m_excludeFilters == null ? other.m_excludeFilters != null : !this.m_excludeFilters.equals(other.m_excludeFilters)) {
            return false;
        }
        return !(this.m_systemDef == null ? other.m_systemDef != null : !this.m_systemDef.equals(other.m_systemDef));
    }

    public String toString() {
        return "IncludeCollection [systemDef=" + this.m_systemDef + ", dataCollectionGroup=" + this.m_dataCollectionGroup + ", excludeFilters=" + String.valueOf(this.m_excludeFilters) + "]";
    }

    public void visit(DatacollectionConfigVisitor visitor) {
        visitor.visitIncludeCollection(this);
        visitor.visitIncludeCollectionComplete();
    }
}

