/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.rest.impl;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentService;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.opennms.netmgt.graph.rest.api.GraphRestService;
import org.opennms.netmgt.graph.rest.api.Query;
import org.opennms.netmgt.graph.rest.impl.converter.JsonConverterService;
import org.opennms.netmgt.graph.rest.impl.renderer.JsonGraphRenderer;
import org.osgi.framework.BundleContext;

public class GraphRestServiceImpl
implements GraphRestService {
    private final BundleContext bundleContext;
    private final GraphService graphService;
    private final EnrichmentService enrichmentService;

    public GraphRestServiceImpl(GraphService graphService, EnrichmentService enrichmentService, BundleContext bundleContext) {
        this.graphService = Objects.requireNonNull(graphService);
        this.enrichmentService = Objects.requireNonNull(enrichmentService);
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public Response listContainerInfo() {
        List graphContainerInfos = this.graphService.getGraphContainerInfos();
        if (graphContainerInfos.isEmpty()) {
            return Response.noContent().build();
        }
        String rendered = this.render(graphContainerInfos);
        return Response.ok((Object)rendered).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public Response getContainer(String containerId) {
        GenericGraphContainer container = this.graphService.getGraphContainer(containerId);
        if (container == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String rendered = this.render((ImmutableGraphContainer)container);
        return Response.ok((Object)rendered).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public Response getGraph(String containerId, String namespace) {
        GenericGraph graph = this.graphService.getGraph(containerId, namespace);
        if (graph == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String rendered = this.render((ImmutableGraph)graph);
        return Response.ok((Object)rendered).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public Response getView(String containerId, String namespace, Query query) {
        GenericGraph graph = this.graphService.getGraph(containerId, namespace);
        if (graph == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (query.getSemanticZoomLevel() == null) {
            query.setSemanticZoomLevel(Integer.valueOf(1));
        }
        if (query.getSemanticZoomLevel() < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new JSONObject().put("error", (Object)("SemanticZoomLevel must be >= 0 but was " + query.getSemanticZoomLevel())).toString()).build();
        }
        if (query.getVerticesInFocus() == null || query.getVerticesInFocus().isEmpty()) {
            query.setVerticesInFocus(graph.getDefaultFocus().getVertexIds());
        }
        List focussedVertices = graph.resolveVertices((Collection)query.getVerticesInFocus());
        GenericGraph view = graph.getView((Collection)focussedVertices, query.getSemanticZoomLevel().intValue()).asGenericGraph();
        GenericGraph enrichedView = this.enrichmentService.enrich(view);
        JSONObject jsonView = new JsonConverterService(this.bundleContext).convert((ImmutableGraph<?, ?>)enrichedView);
        jsonView.put("focus", (Object)GraphRestServiceImpl.convert(query));
        jsonView.remove("defaultFocus");
        return Response.ok((Object)jsonView.toString()).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private static JSONObject convert(Query query) {
        JSONObject jsonQuery = new JSONObject();
        jsonQuery.put("semanticZoomLevel", (Object)query.getSemanticZoomLevel());
        jsonQuery.put("vertices", (Collection)query.getVerticesInFocus());
        return jsonQuery;
    }

    private String render(List<GraphContainerInfo> infos) {
        return new JsonGraphRenderer(this.bundleContext).render(infos);
    }

    private String render(ImmutableGraphContainer graphContainer) {
        return new JsonGraphRenderer(this.bundleContext).render(graphContainer);
    }

    private String render(ImmutableGraph graph) {
        return new JsonGraphRenderer(this.bundleContext).render(graph);
    }
}

