/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.samplewrite;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class MetaTagConfiguration {
    static final String CONFIG_PREFIX = "org.opennms.timeseries.tin.metatags";
    static final String CONFIG_KEY_FOR_CATEGORIES = "org.opennms.timeseries.tin.metatags.exposeCategories";
    static final String CONFIG_PREFIX_FOR_TAGS = "org.opennms.timeseries.tin.metatags.tag.";
    private final boolean categoriesEnabled;
    private final Map<String, String> configuredMetaTags;

    public MetaTagConfiguration(Map<String, String> properties) {
        this.categoriesEnabled = Optional.ofNullable(properties.get(CONFIG_KEY_FOR_CATEGORIES)).map(Boolean::valueOf).orElse(false);
        this.configuredMetaTags = this.findConfiguredMetaTags(properties);
    }

    public Map<String, String> getConfiguredMetaTags() {
        return this.configuredMetaTags;
    }

    public boolean isCategoriesEnabled() {
        return this.categoriesEnabled;
    }

    private Map<String, String> findConfiguredMetaTags(Map<String, String> properties) {
        HashMap filteredMap = new HashMap();
        return properties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(CONFIG_PREFIX_FOR_TAGS)).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(CONFIG_PREFIX_FOR_TAGS.length()), Map.Entry::getValue));
    }
}

