/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.ops4j.pax.swissbox.core.ContextClassLoaderUtils;
import org.ops4j.pax.web.service.jetty.internal.ConfigureRequestLogParameter;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceContext;
import org.ops4j.pax.web.service.jetty.internal.JettyServer;
import org.ops4j.pax.web.service.jetty.internal.JettyServerWrapper;
import org.ops4j.pax.web.service.jetty.internal.ResourceServlet;
import org.ops4j.pax.web.service.spi.LifeCycle;
import org.ops4j.pax.web.service.spi.model.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.ResourceModel;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.ops4j.pax.web.service.spi.model.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.util.ResourceDelegatingBundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JettyServerImpl
implements JettyServer {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServerImpl.class);
    private final JettyServerWrapper server;
    private Bundle bundle;
    private MBeanContainer mBeanContainer;
    private Comparator<?> priorityComparator;

    JettyServerImpl(ServerModel serverModel, Bundle bundle) {
        this(serverModel, bundle, null, null);
    }

    public JettyServerImpl(ServerModel serverModel, Bundle bundle, Comparator<?> priorityComparator, ThreadPool threadPool) {
        this.server = new JettyServerWrapper(serverModel, threadPool);
        this.bundle = bundle;
        this.priorityComparator = priorityComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        LOG.debug("Starting " + this);
        try {
            File serverConfigurationFile;
            URL jettyResource = this.getServerConfigURL();
            if (jettyResource == null) {
                jettyResource = this.getClass().getResource("/jetty.xml");
            }
            if ((serverConfigurationFile = this.getServerConfigDir()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("server configuration file location: " + serverConfigurationFile);
                }
                if (!serverConfigurationFile.isDirectory() && serverConfigurationFile.canRead()) {
                    String fileName;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("server configuration directory exists and is readable");
                    }
                    if ((fileName = serverConfigurationFile.getName()).equalsIgnoreCase("jetty.xml")) {
                        jettyResource = serverConfigurationFile.toURI().toURL();
                    } else {
                        LOG.warn("No configuration file found with name jetty.xml. Filename given: {}, will read this one instead. ", (Object)fileName);
                        jettyResource = serverConfigurationFile.toURI().toURL();
                    }
                } else {
                    LOG.warn("server configuration file location is invalid");
                }
            }
            if (jettyResource != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    ClassLoader jettyXmlCl = null;
                    for (Bundle b : this.bundle.getBundleContext().getBundles()) {
                        if (!"org.eclipse.jetty.xml".equals(b.getSymbolicName())) continue;
                        jettyXmlCl = ((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader();
                        break;
                    }
                    Thread.currentThread().setContextClassLoader(jettyXmlCl);
                    LOG.debug("Configure using resource " + jettyResource);
                    XmlConfiguration configuration = new XmlConfiguration(jettyResource);
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    Method method = XmlConfiguration.class.getMethod("configure", Object.class);
                    method.invoke((Object)configuration, new Object[]{this.server});
                }
                finally {
                    Thread.currentThread().setContextClassLoader(loader);
                }
            }
            try {
                Class.forName("javax.management.JMX");
                Class.forName("org.eclipse.jetty.jmx.MBeanContainer");
                this.mBeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
                this.server.addBean(this.mBeanContainer);
            }
            catch (Throwable t) {
                LOG.debug("No JMX available will keep going");
            }
            Connector[] connectors = this.server.getConnectors();
            if (connectors != null) {
                for (Connector connector : connectors) {
                    LOG.info("Pax Web available at [{}]:[{}]", (Object)(((ServerConnector)connector).getHost() == null ? "0.0.0.0" : ((ServerConnector)connector).getHost()), (Object)((ServerConnector)connector).getPort());
                }
            } else {
                LOG.info("Pax Web is started with it's default configuration most likely it's listening on port 8181");
            }
        }
        catch (Exception e) {
            LOG.error("Exception while starting Jetty", (Throwable)e);
            throw new RuntimeException("Exception while starting Jetty", e);
        }
    }

    @Override
    public void stop() {
        LOG.debug("Stopping " + this);
        try {
            Handler[] childHandlers;
            try {
                Class.forName("javax.management.JMX");
                if (this.mBeanContainer != null) {
                    this.server.removeBean(this.mBeanContainer);
                    this.mBeanContainer.destroy();
                    this.mBeanContainer = null;
                }
            }
            catch (Throwable t) {
                LOG.debug("No JMX available will keep going");
            }
            this.server.stop();
            for (Handler handler : childHandlers = this.server.getChildHandlers()) {
                handler.stop();
            }
            if (this.server.getThreadPool() instanceof org.eclipse.jetty.util.component.LifeCycle) {
                ((org.eclipse.jetty.util.component.LifeCycle)this.server.getThreadPool()).stop();
            }
            this.server.destroy();
        }
        catch (Exception e) {
            LOG.error("Exception while stopping Jetty:", (Throwable)e);
        }
    }

    @Override
    public void addConnector(Connector connector) {
        LOG.info("Pax Web available at [{}]:[{}]", (Object)(((ServerConnector)connector).getHost() == null ? "0.0.0.0" : ((ServerConnector)connector).getHost()), (Object)((ServerConnector)connector).getPort());
        this.server.addConnector(connector);
        if (this.priorityComparator != null) {
            Connector[] connectors = this.server.getConnectors();
            Comparator<?> comparator = this.priorityComparator;
            Arrays.sort(connectors, comparator);
        }
    }

    @Override
    public Connector[] getConnectors() {
        return this.server.getConnectors();
    }

    @Override
    public void removeConnector(Connector connector) {
        LOG.info("Removing connection for [{}]:[{}]", (Object)(((ServerConnector)connector).getHost() == null ? "0.0.0.0" : ((ServerConnector)connector).getHost()), (Object)((ServerConnector)connector).getPort());
        this.server.removeConnector(connector);
    }

    @Override
    public void addHandler(Handler handler) {
        HandlerCollection handlerCollection = this.server.getRootHandlerCollection();
        handlerCollection.addHandler(handler);
        if (this.priorityComparator != null) {
            Handler[] handlers = handlerCollection.getHandlers();
            Comparator<?> comparator = this.priorityComparator;
            Arrays.sort(handlers, comparator);
        }
    }

    @Override
    public Handler[] getHandlers() {
        return this.server.getRootHandlerCollection().getHandlers();
    }

    @Override
    public void removeHandler(Handler handler) {
        this.server.getRootHandlerCollection().removeHandler(handler);
    }

    @Override
    public void configureContext(Map<String, Object> attributes, Integer sessionTimeout, String sessionCookie, String sessionDomain, String sessionPath, String sessionUrl, Boolean sessionCookieHttpOnly, Boolean sessionCookieSecure, String workerName, Boolean lazyLoad, String storeDirectory, Integer maxAge, Boolean showStacks) {
        this.server.configureContext(attributes, sessionTimeout, sessionCookie, sessionDomain, sessionPath, sessionUrl, sessionCookieHttpOnly, sessionCookieSecure, workerName, lazyLoad, storeDirectory, maxAge, showStacks);
    }

    @Override
    public LifeCycle getContext(final ContextModel model) {
        final HttpServiceContext context = this.server.getOrCreateContext(model);
        return new LifeCycle(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void start() throws Exception {
                if (JettyServerImpl.this.server.getThreadPool() instanceof org.eclipse.jetty.util.component.LifeCycle) {
                    ((org.eclipse.jetty.util.component.LifeCycle)JettyServerImpl.this.server.getThreadPool()).start();
                }
                if (!context.isStarted()) {
                    ClassLoader classLoader = context.getClassLoader();
                    ServletMapping[] bundles = ((ResourceDelegatingBundleClassLoader)classLoader).getBundles();
                    BundleClassLoader parentClassLoader = new BundleClassLoader(JettyServerImpl.this.bundle);
                    ResourceDelegatingBundleClassLoader containerSpecificClassLoader = new ResourceDelegatingBundleClassLoader((List)bundles, (ClassLoader)parentClassLoader);
                    context.setClassLoader((ClassLoader)containerSpecificClassLoader);
                    context.start();
                }
                boolean hasDefault = false;
                if (context.getServletHandler() != null && context.getServletHandler().getServletMappings() != null) {
                    for (ServletMapping mapping : context.getServletHandler().getServletMappings()) {
                        if (!mapping.isDefault()) continue;
                        hasDefault = true;
                        break;
                    }
                }
                if (!hasDefault) {
                    ResourceServlet servlet = new ResourceServlet((HttpContext)model.getHttpContext(), model.getContextName(), "/", "default");
                    ResourceModel resourceModel = new ResourceModel(model, (Servlet)servlet, "/", "default");
                    JettyServerImpl.this.addServlet((ServletModel)resourceModel);
                }
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    JettyServerImpl.this.server.start();
                    ServerConnector.class.getClassLoader().loadClass("org.eclipse.jetty.util.FutureCallback");
                    QueuedThreadPool.class.getClassLoader().loadClass("org.eclipse.jetty.util.thread.QueuedThreadPool$1");
                }
                finally {
                    Thread.currentThread().setContextClassLoader(loader);
                }
                for (Connector connector : JettyServerImpl.this.server.getConnectors()) {
                    if (!connector.isStopped()) continue;
                    connector.start();
                }
            }

            public void stop() throws Exception {
                context.stop();
            }
        };
    }

    @Override
    public synchronized void addServlet(ServletModel model) {
        HttpServiceContext context;
        ServletHandler servletHandler;
        LOG.debug("Adding servlet [" + model + "]");
        final ServletMapping mapping = new ServletMapping();
        mapping.setServletName(model.getName());
        mapping.setPathSpecs(model.getUrlPatterns());
        if (model instanceof ResourceModel && "default".equalsIgnoreCase(model.getName())) {
            mapping.setDefault(true);
        }
        if ((servletHandler = (context = this.server.getOrCreateContext((Model)model)).getServletHandler()) == null) {
            throw new IllegalStateException("Internal error: Cannot find the servlet holder");
        }
        final ServletHolder holder = model.getServlet() == null ? new ServletHolder(model.getServletClass()) : new ServletHolder(model.getServlet());
        holder.setName(model.getName());
        if (model.getInitParams() != null) {
            holder.setInitParameters(model.getInitParams());
        }
        if (model.getAsyncSupported() != null) {
            holder.setAsyncSupported(model.getAsyncSupported().booleanValue());
        }
        if (model.getLoadOnStartup() != null) {
            holder.setInitOrder(model.getLoadOnStartup().intValue());
        }
        if (model.getMultipartConfig() != null) {
            holder.getRegistration().setMultipartConfig(model.getMultipartConfig());
        }
        try {
            ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                @Override
                public Void call() {
                    servletHandler.addServlet(holder);
                    servletHandler.addServletMapping(mapping);
                    return null;
                }
            });
            if (holder.isStarted()) {
                holder.getServlet();
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            LOG.error("Ignored exception during servlet registration", (Throwable)e);
        }
    }

    @Override
    public synchronized void removeServlet(ServletModel model) {
        ServletHolder holder;
        LOG.debug("Removing servlet [" + model + "]");
        boolean removed = false;
        HttpServiceContext context = this.server.getContext((HttpContext)model.getContextModel().getHttpContext());
        if (context == null) {
            return;
        }
        ServletHandler servletHandler = context.getServletHandler();
        Object[] holders = servletHandler.getServlets();
        if (holders != null && (holder = servletHandler.getServlet(model.getName())) != null) {
            servletHandler.setServlets((ServletHolder[])ArrayUtil.removeFromArray((Object[])holders, (Object)holder));
            Object[] mappings = servletHandler.getServletMappings();
            if (mappings != null) {
                ServletMapping mapping = null;
                for (ServletMapping servletMapping : mappings) {
                    if (!holder.getName().equals(servletMapping.getServletName())) continue;
                    mapping = servletMapping;
                    break;
                }
                if (mapping != null) {
                    servletHandler.setServletMappings((ServletMapping[])ArrayUtil.removeFromArray((Object[])mappings, mapping));
                    removed = true;
                }
            }
            LOG.debug("Stopping servlet in Holder");
            try {
                ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        holder.stop();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                LOG.warn("Exception during unregistering of servlet [" + model + "]");
            }
        }
        this.removeContext((HttpContext)model.getContextModel().getHttpContext());
        if (!removed) {
            throw new IllegalStateException(model + " was not found");
        }
    }

    @Override
    public synchronized void addEventListener(EventListenerModel model) {
        this.server.getOrCreateContext((Model)model).addEventListener(model.getEventListener());
    }

    @Override
    public synchronized void removeEventListener(EventListenerModel model) {
        HttpServiceContext context = this.server.getContext((HttpContext)model.getContextModel().getHttpContext());
        if (context == null) {
            return;
        }
        ArrayList<EventListener> listeners = new ArrayList<EventListener>(Arrays.asList(context.getEventListeners()));
        EventListener listener = model.getEventListener();
        listeners.remove(listener);
        context.setEventListeners(listeners.toArray(new EventListener[listeners.size()]));
        this.removeContext((HttpContext)model.getContextModel().getHttpContext());
    }

    @Override
    public synchronized void removeContext(HttpContext httpContext) {
        this.server.removeContext(httpContext, false);
    }

    @Override
    public synchronized void removeContext(HttpContext httpContext, boolean force) {
        this.server.removeContext(httpContext, force);
    }

    @Override
    public synchronized void addFilter(FilterModel model) {
        LOG.debug("Adding filter model [" + model + "]");
        final FilterMapping mapping = new FilterMapping();
        mapping.setFilterName(model.getName());
        if (model.getUrlPatterns() != null && model.getUrlPatterns().length > 0) {
            mapping.setPathSpecs(model.getUrlPatterns());
        }
        if (model.getServletNames() != null && model.getServletNames().length > 0) {
            mapping.setServletNames(model.getServletNames());
        }
        int dispatcher = 0;
        for (String d : model.getDispatcher()) {
            if ("ALL".equalsIgnoreCase(d)) {
                dispatcher |= 0x1F;
                continue;
            }
            if ("ASYNC".equalsIgnoreCase(d)) {
                dispatcher |= 0x10;
                continue;
            }
            if ("DEFAULT".equalsIgnoreCase(d)) {
                dispatcher |= 0;
                continue;
            }
            if ("ERROR".equalsIgnoreCase(d)) {
                dispatcher |= 8;
                continue;
            }
            if ("FORWARD".equalsIgnoreCase(d)) {
                dispatcher |= 2;
                continue;
            }
            if ("INCLUDE".equalsIgnoreCase(d)) {
                dispatcher |= 4;
                continue;
            }
            if (!"REQUEST".equalsIgnoreCase(d)) continue;
            dispatcher |= 1;
        }
        mapping.setDispatches(dispatcher);
        HttpServiceContext context = this.server.getOrCreateContext((Model)model);
        final ServletHandler servletHandler = context.getServletHandler();
        if (servletHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the servlet holder");
        }
        final FilterHolder holder = model.getFilter() == null ? new FilterHolder(model.getFilterClass()) : new FilterHolder(model.getFilter());
        holder.setName(model.getName());
        if (model.getInitParams() != null) {
            holder.setInitParameters(model.getInitParams());
        }
        holder.setAsyncSupported(model.isAsyncSupported());
        try {
            ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                @Override
                public Void call() {
                    servletHandler.addFilter(holder, mapping);
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            LOG.error("Ignored exception during filter registration", (Throwable)e);
        }
    }

    @Override
    public synchronized void removeFilter(FilterModel model) {
        LOG.debug("Removing filter model [" + model + "]");
        HttpServiceContext context = this.server.getContext((HttpContext)model.getContextModel().getHttpContext());
        if (context == null) {
            return;
        }
        final ServletHandler servletHandler = context.getServletHandler();
        FilterMapping[] filterMappings = servletHandler.getFilterMappings();
        final ArrayList newFilterMappings = new ArrayList();
        for (FilterMapping filterMapping : filterMappings) {
            if (!filterMapping.getFilterName().equals(model.getName())) continue;
            if (newFilterMappings.isEmpty()) {
                Collections.addAll(newFilterMappings, filterMappings);
            }
            newFilterMappings.remove(filterMapping);
        }
        try {
            ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                @Override
                public Void call() {
                    servletHandler.setFilterMappings(newFilterMappings.toArray(new FilterMapping[newFilterMappings.size()]));
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            LOG.error("Ignored exception during filter registration", (Throwable)e);
        }
        final FilterHolder filterHolder = servletHandler.getFilter(model.getName());
        if (filterHolder == null) {
            return;
        }
        Object[] filterHolders = servletHandler.getFilters();
        FilterHolder[] newFilterHolders = (FilterHolder[])ArrayUtil.removeFromArray((Object[])filterHolders, (Object)filterHolder);
        servletHandler.setFilters(newFilterHolders);
        if (filterHolder.isStarted()) {
            try {
                ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        filterHolder.stop();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                LOG.warn("Exception during unregistering of filter [" + filterHolder.getFilter() + "]");
            }
        }
        this.removeContext((HttpContext)model.getContextModel().getHttpContext());
    }

    @Override
    public synchronized void addErrorPage(ErrorPageModel model) {
        HttpServiceContext context = this.server.getOrCreateContext((Model)model);
        ErrorPageErrorHandler errorPageHandler = (ErrorPageErrorHandler)context.getErrorHandler();
        if (errorPageHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the error handler. Please report.");
        }
        try {
            int code = Integer.parseInt(model.getError());
            errorPageHandler.addErrorPage(code, model.getLocation());
        }
        catch (NumberFormatException nfe) {
            if ("org.ops4j.pax.web.error.error_page.global".equalsIgnoreCase(model.getError())) {
                errorPageHandler.addErrorPage("org.eclipse.jetty.server.error_page.global", model.getLocation());
            }
            if ("4xx".equals(model.getError())) {
                errorPageHandler.addErrorPage(400, 499, model.getLocation());
            }
            if ("5xx".equals(model.getError())) {
                errorPageHandler.addErrorPage(500, 599, model.getLocation());
            }
            errorPageHandler.addErrorPage(model.getError(), model.getLocation());
        }
    }

    @Override
    public synchronized void removeErrorPage(ErrorPageModel model) {
        HttpServiceContext context = this.server.getContext((HttpContext)model.getContextModel().getHttpContext());
        if (context == null) {
            return;
        }
        ErrorPageErrorHandler errorPageHandler = (ErrorPageErrorHandler)context.getErrorHandler();
        if (errorPageHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the error handler. Please report.");
        }
        Map errorPages = errorPageHandler.getErrorPages();
        if (errorPages != null) {
            errorPages.remove(model.getError());
        }
        this.removeContext((HttpContext)model.getContextModel().getHttpContext());
    }

    @Override
    public synchronized void addWelcomeFiles(WelcomeFileModel model) {
        HttpServiceContext context = this.server.getOrCreateContext((Model)model);
        context.setWelcomeFiles(model.getWelcomeFiles());
        if (context.getServletHandler() == null || context.getServletHandler().getServletMappings() == null) {
            return;
        }
        for (ServletMapping mapping : context.getServletHandler().getServletMappings()) {
            ServletHolder servlet = context.getServletHandler().getServlet(mapping.getServletName());
            try {
                if (!(servlet.getServlet() instanceof ResourceServlet)) continue;
                LOG.debug("Reinitializing {} with new welcome files {}", (Object)servlet, Arrays.asList(model.getWelcomeFiles()));
                servlet.getServlet().init(servlet.getServlet().getServletConfig());
            }
            catch (ServletException e) {
                LOG.warn("Problem reinitializing welcome files of default servlet", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void removeWelcomeFiles(WelcomeFileModel model) {
        HttpServiceContext context = this.server.getContext((HttpContext)model.getContextModel().getHttpContext());
        if (context == null) {
            return;
        }
        String[] welcomeFiles = context.getWelcomeFiles();
        ArrayList<String> welcomeFileList = new ArrayList<String>(Arrays.asList(welcomeFiles));
        welcomeFileList.removeAll(Arrays.asList(model.getWelcomeFiles()));
        this.removeContext((HttpContext)model.getContextModel().getHttpContext());
    }

    @Override
    public void addSecurityConstraintMappings(SecurityConstraintMappingModel model) {
        HttpServiceContext context = this.server.getOrCreateContext((Model)model);
        SecurityHandler securityHandler = context.getSecurityHandler();
        if (securityHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the security handler. Please report.");
        }
        String mappingMethod = model.getMapping();
        String constraintName = model.getConstraintName();
        String url = model.getUrl();
        String dataConstraint = model.getDataConstraint();
        List roles = model.getRoles();
        boolean authentication = model.isAuthentication();
        ConstraintMapping newConstraintMapping = new ConstraintMapping();
        newConstraintMapping.setMethod(mappingMethod);
        newConstraintMapping.setPathSpec(url);
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(authentication);
        constraint.setName(constraintName);
        constraint.setRoles(roles.toArray(new String[roles.size()]));
        if (dataConstraint == null || "NONE".equals(dataConstraint)) {
            constraint.setDataConstraint(0);
        } else if ("INTEGRAL".equals(dataConstraint)) {
            constraint.setDataConstraint(1);
        } else if ("CONFIDENTIAL".equals(dataConstraint)) {
            constraint.setDataConstraint(2);
        } else {
            LOG.warn("Unknown user-data-constraint:" + dataConstraint);
            constraint.setDataConstraint(2);
        }
        newConstraintMapping.setConstraint(constraint);
        ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(newConstraintMapping);
    }

    @Override
    public void addServletContainerInitializer(ContainerInitializerModel model) {
    }

    @Override
    public void removeSecurityConstraintMappings(SecurityConstraintMappingModel model) {
        HttpServiceContext context = this.server.getContext((HttpContext)model.getContextModel().getHttpContext());
        if (context == null) {
            return;
        }
        SecurityHandler securityHandler = context.getSecurityHandler();
        if (securityHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the security handler. Please report.");
        }
        List constraintMappings = ((ConstraintSecurityHandler)securityHandler).getConstraintMappings();
        for (ConstraintMapping constraintMapping : constraintMappings) {
            boolean methodMatch;
            boolean urlMatch = constraintMapping.getPathSpec().equalsIgnoreCase(model.getUrl());
            boolean bl = methodMatch = constraintMapping.getMethod() == null && model.getMapping() == null || constraintMapping.getMethod().equalsIgnoreCase(model.getMapping());
            if (!urlMatch || !methodMatch) continue;
            constraintMappings.remove(constraintMapping);
        }
        this.removeContext((HttpContext)model.getContextModel().getHttpContext());
    }

    @Override
    public void configureRequestLog(ConfigureRequestLogParameter configureRequestParameters) {
        File file;
        String directory = configureRequestParameters.dir;
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        if (directory == null || directory.isEmpty()) {
            directory = "./logs/";
        }
        if (!(file = new File(directory)).exists()) {
            file.mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                LOG.error("can't create NCSARequestLog", (Throwable)e);
            }
        }
        LOG.info("NCSARequestlogging is using the following directory: {}", (Object)file.getAbsolutePath());
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        NCSARequestLog requestLog = new NCSARequestLog(directory + configureRequestParameters.format);
        requestLog.setRetainDays(Integer.parseInt(configureRequestParameters.retainDays));
        requestLog.setAppend(configureRequestParameters.append.booleanValue());
        requestLog.setExtended(configureRequestParameters.extend.booleanValue());
        requestLog.setLogDispatch(configureRequestParameters.dispatch.booleanValue());
        requestLog.setLogTimeZone(configureRequestParameters.timeZone);
        requestLog.setLogLatency(configureRequestParameters.logLatency.booleanValue());
        requestLog.setLogCookies(configureRequestParameters.logCookies.booleanValue());
        requestLog.setLogServer(configureRequestParameters.logServer.booleanValue());
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        this.server.getRootHandlerCollection().addHandler((Handler)requestLogHandler);
    }

    public String toString() {
        return JettyServerImpl.class.getSimpleName() + "{}";
    }

    @Override
    public void setServerConfigDir(File serverConfigDir) {
        this.server.setServerConfigDir(serverConfigDir);
    }

    @Override
    public File getServerConfigDir() {
        return this.server.getServerConfigDir();
    }

    @Override
    public void setServerConfigURL(URL serverConfigURL) {
        this.server.setServerConfigURL(serverConfigURL);
    }

    @Override
    public URL getServerConfigURL() {
        return this.server.getServerConfigURL();
    }

    @Override
    public void setDefaultAuthMethod(String defaultAuthMethod) {
        this.server.setDefaultAuthMethod(defaultAuthMethod);
    }

    @Override
    public String getDefaultAuthMethod() {
        return this.server.getDefaultAuthMethod();
    }

    @Override
    public void setDefaultRealmName(String defaultRealmName) {
        this.server.setDefaultRealmName(defaultRealmName);
    }

    @Override
    public String getDefaultRealmName() {
        return this.server.getDefaultRealmName();
    }

    @Override
    public JettyServerWrapper getServer() {
        return this.server;
    }
}

