/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.client.ArrayEnumeration;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPAttribute
implements Cloneable,
Comparable,
Externalizable {
    private String name;
    private String baseName;
    private String[] subTypes = null;
    private Object[] values = null;

    public LDAPAttribute() {
    }

    public LDAPAttribute(LDAPAttribute lDAPAttribute) {
        if (lDAPAttribute == null) {
            throw new IllegalArgumentException("LDAPAttribute class cannot be null");
        }
        this.name = lDAPAttribute.name;
        this.baseName = lDAPAttribute.baseName;
        if (null != lDAPAttribute.subTypes) {
            this.subTypes = new String[lDAPAttribute.subTypes.length];
            System.arraycopy(lDAPAttribute.subTypes, 0, this.subTypes, 0, this.subTypes.length);
        }
        if (null != lDAPAttribute.values) {
            this.values = new Object[lDAPAttribute.values.length];
            System.arraycopy(lDAPAttribute.values, 0, this.values, 0, this.values.length);
        }
    }

    public LDAPAttribute(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        this.name = string;
        this.baseName = LDAPAttribute.getBaseName(string);
        this.subTypes = LDAPAttribute.getSubtypes(string);
    }

    public LDAPAttribute(String string, byte[] byArray) {
        this(string);
        if (byArray == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.add(byArray2);
    }

    public LDAPAttribute(String string, String string2) {
        this(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        try {
            this.add(string2.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public LDAPAttribute(String string, String[] stringArray) {
        this(string);
        if (stringArray == null) {
            throw new IllegalArgumentException("Attribute values array cannot be null");
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                if (stringArray[i] == null) {
                    throw new IllegalArgumentException("Attribute value at array index " + i + " cannot be null");
                }
                this.add(stringArray[i].getBytes("UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.toString());
            }
        }
    }

    public Object clone() {
        try {
            Object object = super.clone();
            if (this.values != null) {
                System.arraycopy(this.values, 0, ((LDAPAttribute)object).values, 0, this.values.length);
            }
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    public void addValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        try {
            this.add(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public void addValue(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        this.add(byArray);
    }

    public void addBase64Value(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        this.add(Base64.decode(string));
    }

    public void addBase64Value(StringBuffer stringBuffer, int n, int n2) {
        if (stringBuffer == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        this.add(Base64.decode(stringBuffer, n, n2));
    }

    public void addBase64Value(char[] cArray) {
        if (cArray == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        this.add(Base64.decode(cArray));
    }

    public void addURLValue(String string) throws MalformedURLException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("Attribute URL cannot be null");
        }
        this.addURLValue(new URL(string));
    }

    public void addURLValue(URL uRL) throws MalformedURLException, IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("Attribute URL cannot be null");
        }
        try {
            int n;
            InputStream inputStream = uRL.openStream();
            class URLData {
                private int length;
                private byte[] data;

                URLData(byte[] byArray, int n) {
                    this.length = n;
                    this.data = byArray;
                }

                private int getLength() {
                    return this.length;
                }

                private byte[] getData() {
                    return this.data;
                }
            }
            ArrayList<URLData> arrayList = new ArrayList<URLData>();
            byte[] byArray = new byte[4096];
            int n2 = 0;
            while ((n = inputStream.read(byArray, 0, 4096)) != -1) {
                arrayList.add(new URLData(byArray, n));
                byArray = new byte[4096];
                n2 += n;
            }
            byte[] byArray2 = new byte[n2];
            int n3 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                URLData uRLData = (URLData)arrayList.get(i);
                n = uRLData.getLength();
                System.arraycopy(uRLData.getData(), 0, byArray2, n3, n);
                n3 += n;
            }
            this.add(byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public Enumeration getByteValues() {
        return new ArrayEnumeration((Object[])this.getByteValueArray());
    }

    public Enumeration getStringValues() {
        return new ArrayEnumeration(this.getStringValueArray());
    }

    public byte[][] getByteValueArray() {
        if (null == this.values) {
            return new byte[0][];
        }
        int n = this.values.length;
        byte[][] byArrayArray = new byte[n][];
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            byArrayArray[i] = new byte[((byte[])this.values[i]).length];
            System.arraycopy(this.values[i], 0, byArrayArray[i], 0, byArrayArray[i].length);
        }
        return byArrayArray;
    }

    public String[] getStringValueArray() {
        if (null == this.values) {
            return new String[0];
        }
        int n = this.values.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            try {
                stringArray[i] = new String((byte[])this.values[i], "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.toString());
            }
        }
        return stringArray;
    }

    public String getStringValue() {
        String string = null;
        if (this.values != null) {
            try {
                string = new String((byte[])this.values[0], "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.toString());
            }
        }
        return string;
    }

    public byte[] getByteValue() {
        byte[] byArray = null;
        if (this.values != null) {
            byArray = new byte[((byte[])this.values[0]).length];
            System.arraycopy(this.values[0], 0, byArray, 0, byArray.length);
        }
        return byArray;
    }

    public String getLangSubtype() {
        if (this.subTypes != null) {
            for (int i = 0; i < this.subTypes.length; ++i) {
                if (!this.subTypes[i].startsWith("lang-")) continue;
                return this.subTypes[i];
            }
        }
        return null;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public static String getBaseName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        int n = string.indexOf(59);
        if (-1 == n) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getName() {
        return this.name;
    }

    public String[] getSubtypes() {
        return this.subTypes;
    }

    public static String[] getSubtypes(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String[] stringArray = null;
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            stringTokenizer.nextToken();
            stringArray = new String[n - 1];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2++] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    public boolean hasSubtype(String string) {
        if (string == null) {
            throw new IllegalArgumentException("subtype cannot be null");
        }
        if (null != this.subTypes) {
            for (int i = 0; i < this.subTypes.length; ++i) {
                if (!this.subTypes[i].equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSubtypes(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("subtypes cannot be null");
        }
        block0: for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < this.subTypes.length; ++j) {
                if (this.subTypes[j] == null) {
                    throw new IllegalArgumentException("subtype at array index " + i + " cannot be null");
                }
                if (this.subTypes[j].equalsIgnoreCase(stringArray[i])) continue block0;
            }
            return false;
        }
        return true;
    }

    public void removeValue(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        try {
            this.removeValue(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public void removeValue(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.equals(byArray, (byte[])this.values[i])) continue;
            if (0 == i && 1 == this.values.length) {
                this.values = null;
                return;
            }
            if (this.values.length == 1) {
                this.values = null;
                break;
            }
            int n = this.values.length - i - 1;
            Object[] objectArray = new Object[this.values.length - 1];
            if (i != 0) {
                System.arraycopy(this.values, 0, objectArray, 0, i);
            }
            if (n != 0) {
                System.arraycopy(this.values, i + 1, objectArray, i, n);
            }
            this.values = objectArray;
            objectArray = null;
            break;
        }
    }

    public int size() {
        return null == this.values ? 0 : this.values.length;
    }

    public int compareTo(Object object) {
        return this.name.compareTo(((LDAPAttribute)object).name);
    }

    private void add(byte[] byArray) {
        if (null == this.values) {
            this.values = new Object[]{byArray};
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.equals(byArray, (byte[])this.values[i])) continue;
                return;
            }
            Object[] objectArray = new Object[this.values.length + 1];
            System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
            objectArray[this.values.length] = byArray;
            this.values = objectArray;
            objectArray = null;
        }
    }

    protected void setValue(String string) {
        this.values = null;
        try {
            this.add(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    private boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n = byArray.length;
        if (byArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPAttribute: ");
        try {
            stringBuffer.append("{type='" + this.name + "'");
            if (this.values != null) {
                stringBuffer.append(", ");
                if (this.values.length == 1) {
                    stringBuffer.append("value='");
                } else {
                    stringBuffer.append("values='");
                }
                for (int i = 0; i < this.values.length; ++i) {
                    if (i != 0) {
                        stringBuffer.append("','");
                    }
                    if (((byte[])this.values[i]).length == 0) continue;
                    String string = new String((byte[])this.values[i], "UTF-8");
                    if (string.length() == 0) {
                        stringBuffer.append("<binary value, length:" + string.length());
                        continue;
                    }
                    stringBuffer.append(string);
                }
                stringBuffer.append("'");
            }
            stringBuffer.append("}");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return stringBuffer.toString();
    }

    void newLine(int n, Writer writer) throws IOException {
        String string = "    ";
        writer.write("\n");
        for (int i = 0; i < n; ++i) {
            writer.write(string);
        }
    }

    public void writeDSML(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<LDAPAttribute>");
        this.newLine(1, outputStreamWriter);
        outputStreamWriter.write("<attr name=\"");
        outputStreamWriter.write(this.getName());
        outputStreamWriter.write("\">");
        this.writeValue(outputStreamWriter);
        this.newLine(1, outputStreamWriter);
        outputStreamWriter.write("</attr>");
        this.newLine(0, outputStreamWriter);
        outputStreamWriter.write("</LDAPAttribute>");
        ((Writer)outputStreamWriter).close();
    }

    protected void writeValue(Writer writer) throws IOException {
        String[] stringArray = this.getStringValueArray();
        byte[][] byArray = this.getByteValueArray();
        for (int i = 0; i < stringArray.length; ++i) {
            this.newLine(2, writer);
            if (Base64.isValidUTF8(byArray[i], false)) {
                writer.write("<value>");
                writer.write(stringArray[i]);
                writer.write("</value>");
                continue;
            }
            writer.write("<value xsi:type=\"xsd:base64Binary\">");
            writer.write(Base64.encode(byArray[i]));
            writer.write("</value>");
        }
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPAttribute.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPAttribute)sAXEventMultiplexer.parseXML(inputStream);
    }

    private static LDAPXMLHandler getTopXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPAttribute.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPAttribute)this.valuelist.get(0));
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator iterator = this.valuelist.iterator();
                LDAPAttribute lDAPAttribute = new LDAPAttribute(this.attrName);
                while (iterator.hasNext()) {
                    lDAPAttribute.addValue((byte[])iterator.next());
                }
                this.setObject(lDAPAttribute);
                this.valuelist.clear();
            }

            protected void addValue(String string, Object object) {
                if (string.equals("value")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string = "";
        string = string + "*************************************************************************\n";
        string = string + "** The encrypted data above and below is the Class definition and  ******\n";
        string = string + "** other data specific to Java Serialization Protocol. The data  ********\n";
        string = string + "** which is of most application specific interest is as follows... ******\n";
        string = string + "*************************************************************************\n";
        string = string + "****************** Start of application data ****************************\n";
        string = string + "*************************************************************************\n";
        stringBuffer.append(string);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append("<LDAPAttribute>");
        stringBuffer.append(ValueXMLhandler.newLine(1));
        stringBuffer.append("<attr name=\"");
        stringBuffer.append(this.getName());
        stringBuffer.append("\">");
        this.writeValue(stringBuffer);
        stringBuffer.append(ValueXMLhandler.newLine(1));
        stringBuffer.append("</attr>");
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append("</LDAPAttribute>");
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string2 = "";
        string2 = string2 + "*************************************************************************\n";
        string2 = string2 + "****************** End of application data ******************************\n";
        string2 = string2 + "*************************************************************************\n";
        stringBuffer.append(string2);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        objectOutput.writeUTF(stringBuffer.toString());
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer = null;
    }

    protected void writeValue(StringBuffer stringBuffer) {
        String[] stringArray = this.getStringValueArray();
        byte[][] byArray = this.getByteValueArray();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(ValueXMLhandler.newLine(2));
            if (Base64.isValidUTF8(byArray[i], false)) {
                stringBuffer.append("<value>");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("</value>");
                continue;
            }
            stringBuffer.append("<value xsi:type=\"xsd:base64Binary\">");
            stringBuffer.append(Base64.encode(byArray[i]));
            stringBuffer.append("</value>");
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = objectInput.readUTF();
        String string2 = string.substring(string.indexOf(60), string.lastIndexOf(62) + 1);
        StringBuffer stringBuffer = new StringBuffer();
        ValueXMLhandler.parseInput(string2, stringBuffer);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
        this.setDeserializedValues(bufferedInputStream);
        bufferedInputStream.close();
    }

    protected void setDeserializedValues(BufferedInputStream bufferedInputStream) throws IOException {
        LDAPAttribute lDAPAttribute = (LDAPAttribute)LDAPAttribute.readDSML(bufferedInputStream);
        this.name = lDAPAttribute.name;
        this.baseName = lDAPAttribute.baseName;
        if (null != lDAPAttribute.subTypes) {
            this.subTypes = new String[lDAPAttribute.subTypes.length];
            System.arraycopy(lDAPAttribute.subTypes, 0, this.subTypes, 0, this.subTypes.length);
        }
        if (null != lDAPAttribute.values) {
            this.values = new Object[lDAPAttribute.values.length];
            System.arraycopy(lDAPAttribute.values, 0, this.values, 0, this.values.length);
        }
        lDAPAttribute = null;
    }
}

