/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.newts;

import org.opennms.netmgt.collection.api.AbstractPersister;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.PersistException;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.newts.NewtsPersistOperationBuilder;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.newts.NewtsWriter;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.newts.api.Context;

public class NewtsPersister
extends AbstractPersister {
    private final RrdRepository m_repository;
    private final NewtsWriter m_newtsWriter;
    private final Context m_context;
    private NewtsPersistOperationBuilder m_builder;

    protected NewtsPersister(ServiceParameters params, RrdRepository repository, NewtsWriter newtsWriter, Context context) {
        super(params, repository);
        this.m_repository = repository;
        this.m_newtsWriter = newtsWriter;
        this.m_context = context;
    }

    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
        if (this.shouldPersist()) {
            CollectionResource resource = group.getResource();
            this.m_builder = new NewtsPersistOperationBuilder(this.m_newtsWriter, this.m_context, this.m_repository, (ResourceIdentifier)resource, group.getName());
            if (resource.getTimeKeeper() != null) {
                this.m_builder.setTimeKeeper(resource.getTimeKeeper());
            }
            this.setBuilder(this.m_builder);
        }
    }

    protected void persistStringAttribute(ResourcePath path, String key, String value) throws PersistException {
        this.m_builder.persistStringAttribute(path, key, value);
    }

    public void completeGroup(AttributeGroup group) {
        if (this.shouldPersist()) {
            this.commitBuilder();
        }
        this.popShouldPersist();
    }
}

