/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.action;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.QueryUtils;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.api.UrlUtils;
import org.opennms.web.svclayer.api.RequisitionAccessService;

public class RequisitionSearchProvider
implements SearchProvider {
    private final RequisitionAccessService requisitionAccessService;

    public RequisitionSearchProvider(RequisitionAccessService requisitionAccessService) {
        this.requisitionAccessService = Objects.requireNonNull(requisitionAccessService);
    }

    public SearchContext getContext() {
        return Contexts.Action;
    }

    public SearchResult query(SearchQuery query) {
        List requisitions = Lists.newArrayList((Iterable)this.requisitionAccessService.getRequisitions()).stream().filter(r -> QueryUtils.matches((String)r.getForeignSource(), (String)query.getInput())).sorted(Comparator.comparing(Requisition::getForeignSource)).limit(query.getMaxResults()).collect(Collectors.toList());
        List resultItems = requisitions.stream().map(r -> {
            SearchResultItem searchResultItem = new SearchResultItem();
            searchResultItem.setIdentifier(r.getForeignSource());
            searchResultItem.setUrl(String.format("admin/ng-requisitions/index.jsp#/requisitions/%s", UrlUtils.encode((String)r.getForeignSource())));
            searchResultItem.setLabel(String.format("Edit Requisition '%s'", r.getForeignSource()));
            searchResultItem.setIcon("fa fa-pencil");
            return searchResultItem;
        }).collect(Collectors.toList());
        SearchResult searchResult = new SearchResult(Contexts.Action).withMore(requisitions, resultItems).withResults(resultItems);
        return searchResult;
    }
}

