/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.action;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.QueryUtils;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.providers.action.PrincipalCacheKey;
import org.opennms.web.api.MenuProvider;
import org.opennms.web.navigate.DisplayStatus;
import org.opennms.web.navigate.MenuContext;
import org.opennms.web.navigate.MenuEntry;

public class MenuActionSearchProvider
implements SearchProvider {
    private final LoadingCache<PrincipalCacheKey, List<MenuEntry>> cache;
    private final MenuProvider menuProvider;

    public MenuActionSearchProvider(final MenuProvider menuProvider) {
        this.menuProvider = Objects.requireNonNull(menuProvider);
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(100L).build((CacheLoader)new CacheLoader<PrincipalCacheKey, List<MenuEntry>>(){

            public List<MenuEntry> load(PrincipalCacheKey cacheKey) throws Exception {
                Predicate<MenuEntry> menuFilter = e -> e.getEntries() == null || e.getEntries().isEmpty() && e.getDisplayStatus() == DisplayStatus.DISPLAY_LINK;
                List menu = menuProvider.getMenu((MenuContext)cacheKey);
                List<MenuEntry> actualMenuItems = menu.stream().filter(menuFilter).collect(Collectors.toList());
                menu.removeAll(actualMenuItems);
                List otherTopLevelEntries = menu.stream().flatMap(e -> e.getEntries().stream()).filter(menuFilter).collect(Collectors.toList());
                actualMenuItems.addAll(otherTopLevelEntries);
                return actualMenuItems;
            }
        });
    }

    public SearchContext getContext() {
        return Contexts.Action;
    }

    public SearchResult query(SearchQuery query) {
        List<MenuEntry> searchableMenuItems = this.getSearchableMenuItems(query);
        List menuEntries = searchableMenuItems.stream().filter(item -> QueryUtils.matches((String)item.getName(), (String)query.getInput())).collect(Collectors.toList());
        List subList = QueryUtils.shrink(menuEntries, (int)query.getMaxResults());
        List resultItems = subList.stream().map(entry -> {
            SearchResultItem searchResultItem = new SearchResultItem();
            searchResultItem.setIdentifier(entry.getUrl());
            searchResultItem.setUrl(entry.getUrl());
            searchResultItem.setLabel(String.format("Open %s", entry.getName()));
            return searchResultItem;
        }).collect(Collectors.toList());
        SearchResult searchResult = new SearchResult(Contexts.Action).withMore(menuEntries, resultItems).withResults(resultItems);
        return searchResult;
    }

    private List<MenuEntry> getSearchableMenuItems(SearchQuery query) {
        return (List)this.cache.getUnchecked((Object)new PrincipalCacheKey(query));
    }
}

