/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.search.api.Match;
import org.opennms.netmgt.search.api.SearchResultItem;

public class SearchResultItemBuilder {
    private final String CUSTOM_INFO = System.getProperty("org.opennms.netmgt.search.info", "");
    private final SearchResultItem searchResultItem = new SearchResultItem();

    public SearchResultItemBuilder withOnmsNode(OnmsNode node, EntityScopeProvider entityScopeProvider) {
        Objects.requireNonNull(node);
        this.searchResultItem.setIdentifier(node.getNodeId());
        this.searchResultItem.setUrl("element/node.jsp?node=" + node.getId());
        this.searchResultItem.setLabel(node.getLabel());
        this.searchResultItem.setInfo(Interpolator.interpolate((String)this.CUSTOM_INFO, (Scope)entityScopeProvider.getScopeForNode((Integer)node.getId())).output);
        ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"label", (Object)node.getLabel());
        if (node.getForeignId() != null) {
            properties.put((Object)"foreignId", (Object)node.getForeignId());
        }
        if (node.getForeignSource() != null) {
            properties.put((Object)"foreignSource", (Object)node.getForeignSource());
        }
        this.searchResultItem.setProperties((Map)properties.build());
        return this;
    }

    public SearchResultItemBuilder withMatch(String id, String label, String value) {
        this.searchResultItem.addMatch(new Match(id, label, value));
        return this;
    }

    public SearchResultItemBuilder withWeight(int weight) {
        this.searchResultItem.setWeight(weight);
        return this;
    }

    public SearchResultItem build() {
        return this.searchResultItem;
    }
}

