/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.api.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.opennms.nrtg.api.model.CollectionJob;
import org.opennms.nrtg.api.model.LightweightMeasurementSet;
import org.opennms.nrtg.api.model.MeasurementSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCollectionJob
implements CollectionJob {
    private static final long serialVersionUID = -857193182688356245L;
    private static final String METRIC_TYPE_UNKNOWN = "metricTypeUnknown";
    private static AtomicLong s_idGenerator = new AtomicLong(0L);
    private static Logger logger = LoggerFactory.getLogger(DefaultCollectionJob.class);
    private String m_id = String.valueOf(s_idGenerator.incrementAndGet());
    private String m_site;
    private String m_netInterface;
    private String m_service;
    private int m_nodeId;
    private String m_protocolConfiguration;
    private Map<Set<String>, Set<String>> m_metricSets = new HashMap<Set<String>, Set<String>>();
    private Map<String, ArrayList<String>> m_allMetrics = new HashMap<String, ArrayList<String>>();
    private Map<String, String> m_onmsLogicMetricIdMapping = new HashMap<String, String>();
    private Map<String, Object> m_parameters = null;
    private Date m_creationTimestamp = new Date();
    private Date m_finishedTimestamp = null;

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public void setId(String id) {
        this.m_id = id;
    }

    @Override
    public void setNodeId(int nodeId) {
        this.m_nodeId = nodeId;
    }

    @Override
    public int getNodeId() {
        return this.m_nodeId;
    }

    @Override
    public String getSite() {
        return this.m_site;
    }

    @Override
    public void setSite(String site) {
        this.m_site = site;
    }

    @Override
    public String getNetInterface() {
        return this.m_netInterface;
    }

    @Override
    public void setNetInterface(String netInterface) {
        this.m_netInterface = netInterface;
    }

    @Override
    public String getService() {
        return this.m_service;
    }

    @Override
    public void setService(String service) {
        this.m_service = service;
    }

    @Override
    public String getProtocolConfiguration() {
        return this.m_protocolConfiguration;
    }

    @Override
    public void setProtocolConfiguration(String protocolConfiguration) {
        this.m_protocolConfiguration = protocolConfiguration;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.m_parameters = parameters;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.m_parameters;
    }

    @Override
    public MeasurementSet getMeasurementSet() {
        LightweightMeasurementSet measurementSet = new LightweightMeasurementSet(this.getNodeId(), this.getService(), this.getNetInterface(), this.getFinishedTimestamp());
        for (Set<String> destinationSet : this.m_metricSets.keySet()) {
            Set<String> metricSet = this.m_metricSets.get(destinationSet);
            for (String metricId : metricSet) {
                measurementSet.addMeasurement(metricId, this.getMetricType(metricId), this.getMetricValue(metricId), this.getOnmsLogicMetricId(metricId));
            }
        }
        return measurementSet;
    }

    @Override
    public void setCreationTimestamp(Date creationTimestamp) {
        this.m_creationTimestamp = creationTimestamp;
    }

    @Override
    public Date getCreationTimestamp() {
        return this.m_creationTimestamp;
    }

    @Override
    public Date getFinishedTimestamp() {
        return this.m_finishedTimestamp;
    }

    @Override
    public void setFinishedTimestamp(Date finishedTimestamp) {
        this.m_finishedTimestamp = finishedTimestamp;
    }

    @Override
    public void addMetric(String metricId, Set<String> destinationSet, String onmsLogicMetricId) throws IllegalArgumentException {
        if (destinationSet == null) {
            throw new IllegalArgumentException("destinationSet must not be null");
        }
        if (destinationSet.isEmpty()) {
            throw new IllegalArgumentException("destinationSet must not be empty");
        }
        if (metricId == null) {
            throw new IllegalArgumentException("metricId must not be null");
        }
        if ("".equals(metricId)) {
            throw new IllegalArgumentException("metricId must not be ''");
        }
        TreeSet<String> destinationSetToUse = new TreeSet<String>(destinationSet);
        for (Set<String> alreadyDefinedDestinationSet : this.m_metricSets.keySet()) {
            if (!this.m_metricSets.get(alreadyDefinedDestinationSet).contains(metricId)) continue;
            if (destinationSetToUse.equals(alreadyDefinedDestinationSet)) {
                return;
            }
            this.m_metricSets.get(alreadyDefinedDestinationSet).remove(metricId);
            destinationSetToUse.addAll(alreadyDefinedDestinationSet);
            logger.debug("Metric " + metricId + "already exists in " + String.valueOf(alreadyDefinedDestinationSet) + ", moving metric to " + String.valueOf(destinationSetToUse));
        }
        if (!this.m_metricSets.containsKey(destinationSetToUse)) {
            this.m_metricSets.put(destinationSetToUse, new HashSet());
        }
        this.m_metricSets.get(destinationSetToUse).add(metricId);
        this.m_allMetrics.put(metricId, null);
        this.m_onmsLogicMetricIdMapping.put(metricId, onmsLogicMetricId);
    }

    @Override
    public void setMetricValue(String metricId, String metricType, String value) throws IllegalArgumentException {
        if (metricId == null) {
            throw new IllegalArgumentException("metricId must not be null");
        }
        if ("".equals(metricId)) {
            throw new IllegalArgumentException("metricId must not be ''");
        }
        if (!this.m_allMetrics.containsKey(metricId)) {
            throw new IllegalArgumentException("metricId is undefined");
        }
        ArrayList<String> valueTypeList = new ArrayList<String>(2);
        valueTypeList.add(metricType);
        valueTypeList.add(value);
        this.m_allMetrics.put(metricId, valueTypeList);
    }

    @Override
    public void setMetricValue(String metricId, String value) throws IllegalArgumentException {
        this.setMetricValue(metricId, METRIC_TYPE_UNKNOWN, value);
    }

    @Override
    public String getMetricValue(String metricId) throws IllegalArgumentException {
        if (metricId == null) {
            throw new IllegalArgumentException("metricId must not be null");
        }
        if ("".equals(metricId)) {
            throw new IllegalArgumentException("metricId must not be ''");
        }
        if (!this.m_allMetrics.containsKey(metricId)) {
            throw new IllegalArgumentException("metricId is undefined");
        }
        return this.m_allMetrics.get(metricId) == null ? null : this.m_allMetrics.get(metricId).get(1);
    }

    @Override
    public String getMetricType(String metricId) throws IllegalArgumentException {
        if (metricId == null) {
            throw new IllegalArgumentException("metricId must not be null");
        }
        if ("".equals(metricId)) {
            throw new IllegalArgumentException("metricId must not be ''");
        }
        if (!this.m_allMetrics.containsKey(metricId)) {
            throw new IllegalArgumentException("metricId is undefined");
        }
        return this.m_allMetrics.get(metricId) == null ? null : this.m_allMetrics.get(metricId).get(0);
    }

    private String getDestinationString(Set<String> destinationSet) {
        StringBuilder destinationStringBuilder = new StringBuilder();
        for (String destination : destinationSet) {
            destinationStringBuilder.append(destination);
            destinationStringBuilder.append(", ");
        }
        return destinationStringBuilder.substring(0, destinationStringBuilder.toString().length() - 2);
    }

    @Override
    public String getOnmsLogicMetricId(String metricId) {
        return this.m_onmsLogicMetricIdMapping.get(metricId);
    }

    @Override
    public Map<String, MeasurementSet> getMeasurementSetsByDestination() {
        TreeMap<String, MeasurementSet> measurementMap = new TreeMap<String, MeasurementSet>();
        for (Set<String> destinationSet : this.m_metricSets.keySet()) {
            LightweightMeasurementSet measurementSet = new LightweightMeasurementSet(this.getNodeId(), this.getService(), this.getNetInterface(), this.getFinishedTimestamp());
            Set<String> metricSet = this.m_metricSets.get(destinationSet);
            for (String metricId : metricSet) {
                measurementSet.addMeasurement(metricId, this.getMetricType(metricId), this.getMetricValue(metricId), this.getOnmsLogicMetricId(metricId));
            }
            measurementMap.put(this.getDestinationString(destinationSet), measurementSet);
        }
        return measurementMap;
    }

    @Override
    public Set<String> getAllMetrics() {
        return this.m_allMetrics.keySet();
    }
}

