/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.consumer;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.opennms.core.ipc.common.kafka.Utils;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.features.kafka.consumer.events.EventsMapper;
import org.opennms.features.kafka.consumer.events.EventsProto;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenNMSKafkaConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(OpenNMSKafkaConsumer.class);
    private final ConfigurationAdmin configAdmin;
    private final EventForwarder eventForwarder;
    private String eventsTopic;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    public static final String KAFKA_CLIENT_PID = "org.opennms.features.kafka.consumer.client";
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("kafka-consumer-events-%d").build();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(this.threadFactory);

    public OpenNMSKafkaConsumer(ConfigurationAdmin configAdmin, EventForwarder eventForwarder) {
        this.configAdmin = configAdmin;
        this.eventForwarder = eventForwarder;
    }

    public void init() throws IOException {
        Properties consumerConfig = new Properties();
        consumerConfig.put("group.id", SystemInfoUtils.getInstanceId());
        Dictionary properties = this.configAdmin.getConfiguration(KAFKA_CLIENT_PID).getProperties();
        if (properties != null) {
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                consumerConfig.put(key, properties.get(key));
            }
        }
        consumerConfig.put("key.deserializer", StringDeserializer.class.getCanonicalName());
        consumerConfig.put("value.deserializer", ByteArrayDeserializer.class.getCanonicalName());
        KafkaConsumerRunner kafkaConsumerRunner = new KafkaConsumerRunner(consumerConfig);
        this.executorService.execute(kafkaConsumerRunner);
    }

    public void shutdown() {
        this.closed.set(true);
        this.executorService.shutdown();
    }

    public void setEventsTopic(String eventsTopic) {
        this.eventsTopic = eventsTopic;
    }

    private class KafkaConsumerRunner
    implements Runnable {
        private final Properties consumerConfig;

        public KafkaConsumerRunner(Properties properties) {
            this.consumerConfig = properties;
        }

        @Override
        public void run() {
            KafkaConsumer consumer = (KafkaConsumer)Utils.runWithGivenClassLoader(() -> new KafkaConsumer(this.consumerConfig), (ClassLoader)KafkaConsumer.class.getClassLoader());
            if (Strings.isNullOrEmpty((String)OpenNMSKafkaConsumer.this.eventsTopic)) {
                LOG.error("EventsTopic is either null or empty, not invoking kafka consumer");
                return;
            }
            consumer.subscribe(Arrays.asList(OpenNMSKafkaConsumer.this.eventsTopic));
            LOG.info("subscribed to {}", (Object)OpenNMSKafkaConsumer.this.eventsTopic);
            while (!OpenNMSKafkaConsumer.this.closed.get()) {
                ConsumerRecords records = consumer.poll(Duration.ofMillis(Long.MAX_VALUE));
                LOG.trace("Received {} records", (Object)records.count());
                ArrayList<EventsProto.Event> pbEvents = new ArrayList<EventsProto.Event>();
                for (ConsumerRecord record : records) {
                    try {
                        EventsProto.Event pbEvent = EventsProto.Event.parseFrom((byte[])record.value());
                        pbEvents.add(pbEvent);
                    }
                    catch (InvalidProtocolBufferException e) {
                        LOG.warn("Error while parsing event with key {}", record.key());
                    }
                }
                this.forwardEventsToOpenNMS(pbEvents);
            }
        }

        void forwardEventsToOpenNMS(List<EventsProto.Event> pbEvents) {
            List<Event> events = EventsMapper.mapProtobufToEvents(pbEvents);
            Log log = new Log();
            events.forEach(arg_0 -> ((Log)log).addEvent(arg_0));
            OpenNMSKafkaConsumer.this.eventForwarder.sendNowSync(log);
            log.getEvents().getEventCollection().forEach(event -> LOG.debug(" Event with uei {}, source {} forwarded to OpenNMS", (Object)event.getUei(), (Object)event.getSource()));
        }
    }
}

