/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.smb.client;

import java.io.IOException;
import java.net.InetAddress;
import jcifs.CIFSContext;
import jcifs.NameServiceClient;
import jcifs.context.SingletonContext;
import jcifs.netbios.NameServiceClientImpl;
import jcifs.netbios.NbtAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.detector.smb.response.NbtAddressResponse;
import org.opennms.netmgt.provision.support.Client;

public class SmbClient
implements Client<LineOrientedRequest, NbtAddressResponse> {
    private NbtAddress m_nbtAddress;
    private NameServiceClient m_nsc;
    private String m_address;

    public void close() {
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        SingletonContext base = SingletonContext.getInstance();
        this.m_nsc = new NameServiceClientImpl((CIFSContext)base);
        this.m_address = InetAddressUtils.str((InetAddress)address);
        this.m_nbtAddress = (NbtAddress)this.m_nsc.getNbtByName(this.m_address);
    }

    public NbtAddressResponse receiveBanner() throws IOException {
        return this.receiveResponse();
    }

    public NbtAddressResponse sendRequest(LineOrientedRequest request) throws IOException, Exception {
        return this.receiveResponse();
    }

    private NbtAddressResponse receiveResponse() {
        NbtAddressResponse nbtAddrResponse = new NbtAddressResponse();
        nbtAddrResponse.receive(this.m_address, this.m_nbtAddress);
        return nbtAddrResponse;
    }
}

