/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.nrtcollector.internal.jms;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.opennms.nrtg.api.model.CollectionJob;
import org.opennms.nrtg.api.model.LightweightMeasurementSet;
import org.opennms.nrtg.nrtcollector.internal.ProtocolCollectorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.SimpleMessageConverter;

public class CollectionJobListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(CollectionJobListener.class);
    private final SimpleMessageConverter simpleMessageConverter = new SimpleMessageConverter();
    private JmsTemplate jmsTemplate;
    private ProtocolCollectorRegistry protocolCollectorRegistry;
    private static AtomicInteger counter = new AtomicInteger(0);

    public CollectionJobListener() {
    }

    public CollectionJobListener(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public ProtocolCollectorRegistry getProtocolCollectorRegistry() {
        return this.protocolCollectorRegistry;
    }

    public void setProtocolCollectorRegistry(ProtocolCollectorRegistry protocolCollectorRegistry) {
        this.protocolCollectorRegistry = protocolCollectorRegistry;
    }

    public void onMessage(Message message) {
        try {
            CollectionJob collectionJob = (CollectionJob)this.simpleMessageConverter.fromMessage(message);
            collectionJob = this.protocolCollectorRegistry.getProtocolCollector(collectionJob.getService()).collect(collectionJob);
            Date finishedTimestamp = new Date();
            collectionJob.setFinishedTimestamp(finishedTimestamp);
            Map measurementSets = collectionJob.getMeasurementSetsByDestination();
            int val = counter.incrementAndGet();
            if (val % 1000 == 0) {
                logger.debug("processed job #{}, {} measurement set(s)", (Object)val, (Object)measurementSets.size());
            } else {
                logger.trace("processed job #{}, {} measurement set(s)", (Object)val, (Object)measurementSets.size());
            }
            for (String destinationString : measurementSets.keySet()) {
                this.jmsTemplate.convertAndSend(destinationString, measurementSets.get(destinationString));
                logger.info("** sending msg '{}' to '{}'", measurementSets.get(destinationString), (Object)destinationString);
            }
            LightweightMeasurementSet errorMeasurementSet = new LightweightMeasurementSet(collectionJob.getNodeId(), collectionJob.getService(), collectionJob.getNetInterface(), collectionJob.getFinishedTimestamp());
            for (String metricId : collectionJob.getAllMetrics()) {
                if (collectionJob.getMetricValue(metricId) == null) {
                    errorMeasurementSet.addMeasurement(metricId, collectionJob.getMetricType(metricId), null, collectionJob.getOnmsLogicMetricId(metricId));
                }
                logger.trace("collected metric of job #{}='{}'", (Object)(String.valueOf(counter) + ": " + metricId), (Object)collectionJob.getMetricValue(metricId));
            }
            if (errorMeasurementSet.getMeasurements().size() > 0) {
                logger.warn("result set of job #{} contains {} null values", (Object)counter, (Object)errorMeasurementSet.getMeasurements().size());
                this.jmsTemplate.convertAndSend("error", (Object)errorMeasurementSet);
                logger.trace("** sending to 'error'");
            }
        }
        catch (JMSException ex) {
            logger.error(ex.getMessage());
        }
        catch (MessageConversionException ex) {
            logger.error(ex.getMessage());
        }
    }
}

