/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.api;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.opennms.netmgt.enlinkd.service.api.Topology;

public class Bridge
implements Topology {
    private final Integer m_nodeId;
    private Integer m_rootPort;
    private boolean m_isRootBridge;
    private Set<String> m_identifiers = new HashSet<String>();
    private String m_designated;

    public Bridge(Integer id) {
        this.m_nodeId = id;
    }

    public Integer getRootPort() {
        return this.m_rootPort;
    }

    public boolean isNewTopology() {
        if (this.m_rootPort != null) {
            return false;
        }
        return !this.m_isRootBridge;
    }

    public void setRootPort(Integer rootPort) {
        this.m_rootPort = rootPort;
        this.m_isRootBridge = false;
    }

    public boolean isRootBridge() {
        return this.m_isRootBridge;
    }

    public void setRootBridge() {
        this.m_isRootBridge = true;
        this.m_rootPort = null;
    }

    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bridge bridge = (Bridge)o;
        return Objects.equals(this.m_nodeId, bridge.m_nodeId);
    }

    public int hashCode() {
        return Objects.hash(this.m_nodeId);
    }

    @Override
    public String printTopology() {
        StringBuilder strbfr = new StringBuilder();
        strbfr.append("bridge: nodeid[");
        strbfr.append(this.m_nodeId);
        strbfr.append("],");
        if (this.m_isRootBridge) {
            strbfr.append(" isRootBridge,");
        } else {
            strbfr.append(" designated port:[");
            strbfr.append(this.m_rootPort);
            strbfr.append("],");
        }
        strbfr.append(" designated:[");
        strbfr.append(this.m_designated);
        strbfr.append("], identifiers:");
        strbfr.append(this.m_identifiers);
        return strbfr.toString();
    }

    public Set<String> getIdentifiers() {
        return this.m_identifiers;
    }

    public void setIdentifiers(Set<String> identifiers) {
        this.m_identifiers = identifiers;
    }

    public String getDesignated() {
        return this.m_designated;
    }

    public void setDesignated(String designated) {
        this.m_designated = designated;
    }

    public void clear() {
        this.m_identifiers.clear();
        this.m_designated = null;
    }
}

