/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.collections.LazySet;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.MonitoringLocationUtils;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.LazyResourceAttributeLoader;
import org.opennms.netmgt.dao.support.NodeResourceType;
import org.opennms.netmgt.dao.support.ServiceResourceType;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;

public abstract class PerspectiveServiceResourceType
implements OnmsResourceType {
    private final ResourceStorageDao resourceStorageDao;
    private final ServiceResourceType serviceType;

    public PerspectiveServiceResourceType(ResourceStorageDao resourceStorageDao, ServiceResourceType serviceType) {
        this.resourceStorageDao = resourceStorageDao;
        this.serviceType = serviceType;
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }

    public boolean isResourceTypeOnParent(OnmsResource parent) {
        if (!NodeResourceType.isNode(parent)) {
            return false;
        }
        return !this.getResourcesForParent(parent).isEmpty();
    }

    public List<OnmsResource> getResourcesForParent(OnmsResource parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        OnmsNode node = ResourceTypeUtils.getNodeFromResource((OnmsResource)parent);
        String residentLocation = MonitoringLocationUtils.getLocationNameOrNullIfDefault(node);
        return node.getIpInterfaces().stream().map(OnmsIpInterface::getIpAddress).map(InetAddressUtils::str).flatMap(ipAddress -> {
            ResourcePath basePath = this.serviceType.getInterfacePath(residentLocation, (String)ipAddress);
            return this.resourceStorageDao.children(new ResourcePath(basePath, new String[]{"perspective"}), 1).stream().map(path -> this.createResource((String)ipAddress, path.getName(), (ResourcePath)path));
        }).collect(Collectors.toList());
    }

    public OnmsResource getChildByName(OnmsResource parent, String ipWithPerspective) {
        int splitIndex = ipWithPerspective.indexOf(64);
        if (splitIndex == -1) {
            return null;
        }
        String ipAddress = ipWithPerspective.substring(0, splitIndex);
        String perspectiveLocation = ipWithPerspective.substring(splitIndex + 1);
        OnmsNode node = ResourceTypeUtils.getNodeFromResource((OnmsResource)parent);
        String residentLocation = MonitoringLocationUtils.getLocationNameOrNullIfDefault(node);
        ResourcePath basePath = this.serviceType.getInterfacePath(residentLocation, ipAddress);
        OnmsResource resource = this.createResource(ipAddress, perspectiveLocation, new ResourcePath(basePath, new String[]{"perspective", perspectiveLocation}));
        resource.setParent(parent);
        return resource;
    }

    private OnmsResource createResource(String ipAddress, String perspectiveLocation, ResourcePath path) {
        LazyResourceAttributeLoader loader = new LazyResourceAttributeLoader(this.resourceStorageDao, path);
        LazySet set = new LazySet((LazySet.Loader)loader);
        return new OnmsResource(String.format("%s@%s", ipAddress, perspectiveLocation), String.format("%s for %s from %s", this.getLabel(), ipAddress, perspectiveLocation), (OnmsResourceType)this, (Set)set, path);
    }
}

