/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collections;
import java.util.SortedMap;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.support.ResourceTreeWalker;
import org.opennms.netmgt.dao.support.ResourceWalker;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceVisitor;
import org.springframework.util.Assert;

public class FilterResourceWalker
implements ResourceWalker {
    private NodeDao m_nodeDao;
    private FilterDao m_filterDao;
    private String m_filter;
    private ResourceDao m_resourceDao;
    private ResourceVisitor m_visitor;
    private ResourceTreeWalker m_resourceWalker = new ResourceTreeWalker();

    @Override
    public void walk() {
        AbstractEntityVisitor visitor = new AbstractEntityVisitor(){

            public void visitNode(OnmsNode node) {
                FilterResourceWalker.this.walk(node);
            }
        };
        SortedMap map = this.getFilterDao().getNodeMap(this.m_filter);
        for (Integer nodeId : map.keySet()) {
            OnmsNode node = (OnmsNode)this.getNodeDao().load(nodeId);
            visitor.visitNode(node);
        }
    }

    public void walk(OnmsNode node) {
        OnmsResource resource = this.getResourceDao().getResourceForNode(node);
        this.m_resourceWalker.walk(Collections.singleton(resource));
    }

    @Override
    public void afterPropertiesSet() {
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"property resourceDao must be set to a non-null value");
        Assert.state((this.m_visitor != null ? 1 : 0) != 0, (String)"property visitor must be set to a non-null value");
        Assert.state((this.m_filterDao != null ? 1 : 0) != 0, (String)"property filterDao must be set to a non-null value");
        Assert.state((this.m_nodeDao != null ? 1 : 0) != 0, (String)"property nodeDao must be set to a non-null value");
        Assert.state((this.m_filter != null ? 1 : 0) != 0, (String)"property filter must be set to a non-null value");
        this.m_resourceWalker.setResourceDao(this.getResourceDao());
        this.m_resourceWalker.setVisitor(this.getVisitor());
        this.m_resourceWalker.afterPropertiesSet();
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    @Override
    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public ResourceVisitor getVisitor() {
        return this.m_visitor;
    }

    @Override
    public void setVisitor(ResourceVisitor visitor) {
        this.m_visitor = visitor;
    }

    public FilterDao getFilterDao() {
        return this.m_filterDao;
    }

    public void setFilterDao(FilterDao filterDao) {
        this.m_filterDao = filterDao;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public void setFilter(String filter) {
        this.m_filter = filter;
    }
}

