/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.dao.api.EventConfEventDao;
import org.opennms.netmgt.model.EventConfEvent;
import org.opennms.netmgt.model.EventConfSource;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.eventconf.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConfServiceHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EventConfServiceHelper.class);

    public static Long saveEvent(EventConfEventDao eventConfEventDao, EventConfSource source, Event event, String username, Date timestamp) {
        EventConfEvent eventConfEvent = new EventConfEvent();
        eventConfEvent.setSource(source);
        eventConfEvent.setUei(event.getUei());
        eventConfEvent.setEventLabel(event.getEventLabel());
        eventConfEvent.setDescription(event.getDescr());
        eventConfEvent.setEnabled(Boolean.valueOf(true));
        eventConfEvent.setSeverity(EventConfServiceHelper.getValidSeverity(event.getSeverity()));
        eventConfEvent.setXmlContent(JaxbUtils.marshal((Object)event));
        eventConfEvent.setCreatedTime(timestamp);
        eventConfEvent.setLastModified(timestamp);
        eventConfEvent.setModifiedBy(username);
        return (Long)eventConfEventDao.save(eventConfEvent);
    }

    public static void reloadEventsFromDB(EventConfEventDao eventConfEventDao, EventConfDao eventConfDao) {
        long startTime = System.currentTimeMillis();
        List<EventConfEvent> dbEvents = eventConfEventDao.findEnabledEvents();
        eventConfDao.loadEventsFromDB(dbEvents);
        long endTime = System.currentTimeMillis();
        LOG.info("Time to reload {} events from DB: {} ms", (Object)dbEvents.size(), (Object)(endTime - startTime));
    }

    public static void reloadEventsFromDBAsync(EventConfEventDao eventConfEventDao, EventConfDao eventConfDao, ExecutorService executor) {
        executor.execute(() -> EventConfServiceHelper.reloadEventsFromDB(eventConfEventDao, eventConfDao));
    }

    public static ExecutorService createEventConfExecutor(String threadNameFormat) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(threadNameFormat).build();
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    public static List<EventConfEvent> createEventConfEventEntities(EventConfSource source, List<Event> events, String username, Date timestamp) {
        return events.stream().map(parsed -> {
            EventConfEvent event = new EventConfEvent();
            event.setSource(source);
            event.setUei(parsed.getUei());
            event.setEventLabel(parsed.getEventLabel());
            event.setDescription(parsed.getDescr());
            event.setEnabled(Boolean.valueOf(true));
            event.setSeverity(EventConfServiceHelper.getValidSeverity(parsed.getSeverity()));
            event.setXmlContent(JaxbUtils.marshal((Object)parsed));
            event.setCreatedTime(timestamp);
            event.setLastModified(timestamp);
            event.setModifiedBy(username);
            return event;
        }).collect(Collectors.toList());
    }

    public static boolean eventsMatch(Event event1, Event event2) {
        if (!Objects.equals(event1.getUei(), event2.getUei())) {
            return false;
        }
        return Objects.equals(event1.getMask(), event2.getMask());
    }

    public static String getValidSeverity(String severity) {
        if (severity == null || severity.isBlank()) {
            return OnmsSeverity.INDETERMINATE.getLabel();
        }
        return OnmsSeverity.get((String)severity).getLabel();
    }
}

